/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.client.neoforge.ClientUtilsImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();

    public static void execClientCommand(String command, boolean printChat) {
        EventResult res;
        if (!command.isEmpty() && Minecraft.getInstance().player != null && !(res = ((ClientChatEvent.Send)ClientChatEvent.SEND.invoker()).send(command, null)).interruptsFurtherEvaluation()) {
            if (printChat) {
                Minecraft.getInstance().gui.getChat().addRecentChat(command);
            }
            Minecraft.getInstance().player.connection.sendCommand(command.replace("/", ""));
        }
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(Screen gui, Class<T> clazz) {
        IScreenWrapper wrapper;
        BaseScreen guiBase;
        if (gui instanceof IScreenWrapper && clazz.isAssignableFrom((guiBase = (wrapper = (IScreenWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? Minecraft.getInstance().screen : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return Minecraft.getInstance().screen == null ? null : (T)ClientUtils.getGuiAs(Minecraft.getInstance().screen, clazz);
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                String uriStr = scheme + ":" + path;
                try {
                    URI uri = new URI(uriStr);
                    if (((Boolean)Minecraft.getInstance().options.chatLinksPrompt().get()).booleanValue()) {
                        Screen currentScreen = Minecraft.getInstance().screen;
                        Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(accepted -> {
                            if (accepted) {
                                Util.getPlatform().openUri(uri);
                            }
                            Minecraft.getInstance().setScreen(currentScreen);
                        }, uriStr, false));
                    } else {
                        Util.getPlatform().openUri(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ClientUtils.logHandleClickFailure(scheme, uriStr, ex);
                    FTBLibrary.LOGGER.warn("handleClick: unexpected exception handling http/https action {}: {}", (Object)uriStr, (Object)ex.getMessage());
                    return false;
                }
            }
            case "file": {
                try {
                    Util.getPlatform().openUri(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ClientUtils.logHandleClickFailure(scheme, path, ex);
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                return staticMethodCache.computeIfAbsent(path, k -> {
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> cls = Class.forName(s[0]);
                        return Optional.ofNullable(MethodHandles.publicLookup().findStatic(cls, s[1], EMPTY_METHOD_TYPE));
                    }
                    catch (ArrayIndexOutOfBoundsException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
                        ClientUtils.logHandleClickFailure(scheme, path, ex);
                        return Optional.empty();
                    }
                }).map(handle -> {
                    try {
                        handle.invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ClientUtils.logHandleClickFailure(scheme, path, ex);
                        return false;
                    }
                }).orElse(false);
            }
            case "custom": {
                return ClientUtils.trySendCustomClickEvent(path);
            }
        }
        return ClientUtils.trySendCustomClickEvent(scheme + ":" + path);
    }

    private static boolean trySendCustomClickEvent(String name) {
        try {
            ResourceLocation rl = ResourceLocation.parse((String)name);
            return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(rl)).isPresent();
        }
        catch (ResourceLocationException ex) {
            ClientUtils.logHandleClickFailure("custom", name, ex);
            return false;
        }
    }

    private static void logHandleClickFailure(String scheme, String path, Throwable ex) {
        FTBLibrary.LOGGER.warn("handleClick: unexpected exception handling action {} / {}: {}", (Object)scheme, (Object)path, (Object)ex.getMessage());
    }

    public static HolderLookup.Provider registryAccess() {
        return Objects.requireNonNull(Minecraft.getInstance().level).registryAccess();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getStillTexture(FluidStack stack) {
        return ClientUtilsImpl.getStillTexture(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidColor(FluidStack stack) {
        return ClientUtilsImpl.getFluidColor(stack);
    }
}

