/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;

public interface IOpenableScreen
extends Runnable {
    public void openGui();

    default public void openGuiLater() {
        ClientUtils.runLater(this);
    }

    default public void closeGui() {
        this.closeGui(true);
    }

    default public void closeGui(boolean openPrevScreen) {
    }

    default public void closeContextMenu() {
        IOpenableScreen iOpenableScreen = this;
        if (iOpenableScreen instanceof Widget) {
            Widget w = (Widget)iOpenableScreen;
            w.getGui().closeContextMenu();
        }
    }

    @Override
    default public void run() {
        if (ClientUtils.getCurrentGuiAs(IOpenableScreen.class) != this) {
            this.openGui();
        }
    }

    default public Runnable openAfter(Runnable runnable) {
        return () -> {
            runnable.run();
            this.run();
        };
    }
}

