/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class SelectFluidScreen
extends ResourceSelectorScreen<FluidStack> {
    public static final SearchModeIndex<ResourceSearchMode<FluidStack>> KNOWN_MODES = (SearchModeIndex)Util.make(new SearchModeIndex(), idx -> idx.appendMode(ResourceSearchMode.ALL_FLUIDS));

    public SelectFluidScreen(FluidConfig config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected int defaultQuantity() {
        return (int)FluidStackHooks.bucketAmount();
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<FluidStack>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, SelectableResource<FluidStack> resource) {
        return new FluidStackButton(this, panel, Objects.requireNonNullElse(resource, SelectableResource.fluid(FluidStack.empty())));
    }

    private class FluidStackButton
    extends ResourceSelectorScreen.ResourceButton {
        private FluidStackButton(SelectFluidScreen selectFluidScreen, Panel panel, SelectableResource<FluidStack> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            return searchTerms.match(RegistrarManager.getId((Object)((FluidStack)this.getStack()).getFluid(), (ResourceKey)Registries.FLUID), ((FluidStack)this.getStack()).getName().getString(), id -> ((FluidStack)this.getStack()).getFluid().builtInRegistryHolder().is(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id)));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (!((FluidStack)this.getStack()).isEmpty()) {
                list.add(((FluidStack)this.getStack()).getName());
                if (((Boolean)FTBLibraryClientConfig.FLUID_MODNAME.get()).booleanValue()) {
                    ModUtils.getModName(((FluidStack)this.getStack()).getFluid()).ifPresent(name -> list.add((Component)Component.literal((String)name).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                }
            }
        }
    }
}

