/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.modules.octavation;

import de.articdive.jnoise.core.api.modules.NoiseModule;
import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSource;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.modules.octavation.fractal_functions.FractalFunction;
import org.jetbrains.annotations.NotNull;

public final class OctavationModule
implements NoiseModule {
    private final NoiseSource noiseSource;
    private final int octaves;
    private final double persistence;
    private final double lacunarity;
    private final FractalFunction fractalFunction;
    private final boolean incrementSeed;
    private final double fractalBounding;

    private OctavationModule(@NotNull NoiseSource noiseSource, int octaves, double persistence, double lacunarity, @NotNull FractalFunction fractalFunction, boolean incrementSeed) {
        this.noiseSource = noiseSource;
        this.octaves = octaves;
        this.persistence = persistence;
        this.lacunarity = lacunarity;
        this.fractalFunction = fractalFunction;
        this.incrementSeed = incrementSeed;
        double fractalBounding = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            fractalBounding += amplitude;
        }
        this.fractalBounding = fractalBounding;
    }

    @Override
    public double evaluateNoise(double x) {
        double output;
        double amplitude = this.persistence;
        if (this.incrementSeed) {
            SeededNoiseGenerator sng = (SeededNoiseGenerator)this.noiseSource;
            long seed = sng.getSeed();
            output = this.fractalFunction.fractalize(sng.evaluateNoise(x, seed)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(sng.evaluateNoise(x *= this.lacunarity, ++seed)) * (amplitude *= this.persistence);
            }
        } else {
            output = this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x *= this.lacunarity)) * (amplitude *= this.persistence);
            }
        }
        return output / this.fractalBounding;
    }

    @Override
    public double evaluateNoise(double x, double y) {
        double output;
        double amplitude = this.persistence;
        if (this.incrementSeed) {
            SeededNoiseGenerator sng = (SeededNoiseGenerator)this.noiseSource;
            long seed = sng.getSeed();
            output = this.fractalFunction.fractalize(sng.evaluateNoise(x, y, seed)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(sng.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity, ++seed)) * (amplitude *= this.persistence);
            }
        } else {
            output = this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x, y)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity)) * (amplitude *= this.persistence);
            }
        }
        return output / this.fractalBounding;
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        double output;
        double amplitude = this.persistence;
        if (this.incrementSeed) {
            SeededNoiseGenerator sng = (SeededNoiseGenerator)this.noiseSource;
            long seed = sng.getSeed();
            output = this.fractalFunction.fractalize(sng.evaluateNoise(x, y, z, seed)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(sng.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, ++seed)) * (amplitude *= this.persistence);
            }
        } else {
            output = this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x, y, z)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * (amplitude *= this.persistence);
            }
        }
        return output / this.fractalBounding;
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        double output;
        double amplitude = this.persistence;
        if (this.incrementSeed) {
            SeededNoiseGenerator sng = (SeededNoiseGenerator)this.noiseSource;
            long seed = sng.getSeed();
            output = this.fractalFunction.fractalize(sng.evaluateNoise(x, y, z, w, seed)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(sng.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, ++seed)) * (amplitude *= this.persistence);
            }
        } else {
            output = this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x, y, z, w)) * amplitude;
            for (int i = 1; i < this.octaves; ++i) {
                output += this.fractalFunction.fractalize(this.noiseSource.evaluateNoise(x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * (amplitude *= this.persistence);
            }
        }
        return output / this.fractalBounding;
    }

    @NotNull
    public static OctavationModuleBuilder newBuilder() {
        return new OctavationModuleBuilder();
    }

    public static final class OctavationModuleBuilder
    implements NoiseSourceBuilder {
        private NoiseSource noiseSource;
        private int octaves = 1;
        private double persistence = 1.0;
        private double lacunarity = 1.0;
        private FractalFunction fractalFunction = FractalFunction.FBM;
        private boolean incrementSeed = false;

        private OctavationModuleBuilder() {
        }

        @NotNull
        public OctavationModuleBuilder setNoiseSource(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("Noise source cannot be null.");
            }
            this.noiseSource = noiseSource;
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setNoiseSource(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("Noise source cannot be null.");
            }
            this.noiseSource = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setOctaves(int octaves) {
            if (octaves <= 0) {
                throw new IllegalArgumentException("The amount of octaves must be a non-zero positive integer.");
            }
            this.octaves = octaves;
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setPersistence(double persistence) {
            if (persistence <= 0.0) {
                throw new IllegalArgumentException("Persistence must be a non-zero positive value.");
            }
            this.persistence = persistence;
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setLacunarity(double lacunarity) {
            if (lacunarity <= 0.0) {
                throw new IllegalArgumentException("Lacunarity must be a non-zero positive value.");
            }
            this.lacunarity = lacunarity;
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setFractalFunction(FractalFunction fractalFunction) {
            if (fractalFunction == null) {
                throw new IllegalArgumentException("Fractal function cannot be null.");
            }
            this.fractalFunction = fractalFunction;
            return this;
        }

        @NotNull
        public OctavationModuleBuilder setIncrementSeed(boolean incrementSeed) {
            this.incrementSeed = incrementSeed;
            return this;
        }

        @Override
        @NotNull
        public OctavationModule build() {
            if (this.noiseSource == null) {
                throw new IllegalArgumentException("Noise source has not been defined.");
            }
            if (this.incrementSeed && !(this.noiseSource instanceof SeededNoiseGenerator)) {
                throw new IllegalArgumentException("Noise source does not have a seed, hence incrementSeed cannot be true!");
            }
            return new OctavationModule(this.noiseSource, this.octaves, this.persistence, this.lacunarity, this.fractalFunction, this.incrementSeed);
        }
    }
}

