/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.white;

import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import org.jetbrains.annotations.NotNull;

public final class WhiteNoiseGenerator
implements SeededNoiseGenerator {
    private final long seed;

    private WhiteNoiseGenerator(long seed) {
        this.seed = seed;
    }

    @Override
    public double evaluateNoise(double x, long seed) {
        return WhiteNoiseGenerator.evaluateCoord1D((long)Math.floor(x), seed);
    }

    @Override
    public double evaluateNoise(double x, double y, long seed) {
        return WhiteNoiseGenerator.evaluateCoord2D((long)Math.floor(x), (long)Math.floor(y), seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, long seed) {
        return WhiteNoiseGenerator.evaluateCoord3D((long)Math.floor(x), (long)Math.floor(y), (long)Math.floor(z), seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        return WhiteNoiseGenerator.evaluateCoord4D((long)Math.floor(x), (long)Math.floor(y), (long)Math.floor(z), (long)Math.floor(w), seed);
    }

    @Override
    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    private static double evaluateCoord1D(long x, long seed) {
        int n = (int)(seed ^ 1619L * x);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord2D(long x, long y, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord3D(long x, long y, long z, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord4D(long x, long y, long z, long w, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        n = (int)((long)n ^ 1013L * w);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    @NotNull
    public static WhiteNoiseBuilder newBuilder() {
        return new WhiteNoiseBuilder();
    }

    public static final class WhiteNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;

        private WhiteNoiseBuilder() {
        }

        @NotNull
        public WhiteNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        @Override
        @NotNull
        public WhiteNoiseGenerator build() {
            return new WhiteNoiseGenerator(this.seed);
        }
    }
}

