/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.terraform.decoration;

import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.terraform.ClentaminatorDecorationPlacer;
import com.moulberry.axiom.tools.terraform.ClentaminatorSettings;
import imgui.ImGui;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public class GrassyDecorationPlacer
implements ClentaminatorDecorationPlacer {
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private final WhiteNoise whiteNoiseBase = new WhiteNoise(1705875030L);
    private final SimplexNoise simplexNoise = new SimplexNoise(-523106418L);
    private final WhiteNoise whiteNoise = new WhiteNoise(-1413739262L);
    private final WhiteNoise whiteNoiseTall = new WhiteNoise(1200178343L);
    private final float grassiness;
    private final boolean allowTallGrass;
    private final class_2680 shortState;
    private final class_2680 tallState;
    private final boolean tallGrassIsActuallyNotTall;

    public GrassyDecorationPlacer(Settings settings) {
        this.tallGrassIsActuallyNotTall = Configuration.capabilities.tallGrassIsActuallyNotTall;
        this.grassiness = settings.grassiness[0];
        this.allowTallGrass = settings.allowTallGrass;
        this.shortState = settings.shortState.getVanillaState();
        this.tallState = settings.tallState.getVanillaState();
    }

    @Override
    public void place(class_1922 blockGetter, ChunkedBlockRegion blockRegion, MaskElement element, MaskContext maskContext, int x, int y, int z) {
        float transformed;
        float whiteBase = this.whiteNoiseBase.evaluate(x, z);
        if (whiteBase > this.grassiness) {
            return;
        }
        float simplex = this.simplexNoise.evaluate((float)x / 12.0f, (float)z / 12.0f);
        float white = this.whiteNoise.evaluate(x, z);
        float f = transformed = (double)white < 0.5 ? (float)Math.sqrt(white / 2.0f) : 1.0f - (float)Math.sqrt((1.0f - white) / 2.0f);
        if (simplex < transformed / 2.0f && this.allowTallGrass) {
            if (this.whiteNoiseTall.evaluate(x, z) < 0.2f && element.test(maskContext.reset(), x, y + 1, z)) {
                blockRegion.addBlock(x, y, z, (class_2680)this.tallState.method_47968((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607));
                if (!this.tallGrassIsActuallyNotTall) {
                    blockRegion.addBlock(x, y + 1, z, (class_2680)this.tallState.method_47968((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609));
                }
            } else {
                blockRegion.addBlock(x, y, z, this.shortState);
            }
        } else if (simplex < transformed) {
            blockRegion.addBlock(x, y, z, this.shortState);
        }
    }

    public static class Settings
    implements ClentaminatorSettings {
        private final float[] grassiness = new float[]{0.5f};
        private boolean allowTallGrass = true;
        private CustomBlockState shortState = (CustomBlockState)class_2246.field_10479.method_9564();
        private CustomBlockState tallState = (CustomBlockState)class_2246.field_10214.method_9564();

        @Override
        public void displayImguiOptions() {
            ImGui.sliderFloat(AxiomI18n.get("axiom.tool.clentaminator.grassiness"), this.grassiness, 0.0f, 1.0f);
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.clentaminator.allow_tall_grass"), this.allowTallGrass)) {
                this.allowTallGrass = !this.allowTallGrass;
            }
            selectBlockWidget.setFilter(ClentaminatorDecorationPlacer.DECORATION_FILTER);
            this.shortState = ImGuiHelper.blockStateWidget(selectBlockWidget, this.shortState, AxiomI18n.get("axiom.tool.clentaminator.grass_block"), 0);
            if (this.allowTallGrass) {
                this.tallState = ImGuiHelper.blockStateWidget(selectBlockWidget, this.tallState, AxiomI18n.get("axiom.tool.clentaminator.tall_grass_block"), 1);
            }
        }

        @Override
        public void writeSettings(class_2487 tag) {
            tag.method_10548("GrassGrassiness", this.grassiness[0]);
            tag.method_10556("GrassAllowTallGrass", this.allowTallGrass);
            tag.method_10582("GrassBlock", ServerCustomBlocks.serialize(this.shortState));
            tag.method_10582("GrassTallBlock", ServerCustomBlocks.serialize(this.tallState));
        }
    }
}

