/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.stamp;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2dSet;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.GenericRadiusAdjustment;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.noise.generic.PositionalRandom;
import com.moulberry.axiom.pather.ToolPatherSurface;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.stamp.IntermediatePlacement;
import com.moulberry.axiom.tools.stamp.StampBlueprintConfig;
import com.moulberry.axiom.tools.stamp.StampPlacement;
import com.moulberry.axiom.tools.stamp.TransformedBlockRegions;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.regions.BooleanRegion;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2335;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class StampTool
implements Tool {
    private final List<StampPlacement> brushPlacements = new ArrayList<StampPlacement>();
    private final List<IntermediatePlacement> intermediatePlacements = new ArrayList<IntermediatePlacement>();
    private final Map<ChunkedBlockRegion, List<class_243>> renderMap = new IdentityHashMap<ChunkedBlockRegion, List<class_243>>();
    private final ChunkedBooleanRegion previewSphere = new ChunkedBooleanRegion();
    private final ChunkedBooleanRegion stampBlocksPreview = new ChunkedBooleanRegion();
    private int oldRadius = -1;
    private int oldBrushShape = -1;
    private boolean usingTool = false;
    private ToolPatherSurface toolPather = null;
    private class_243 lastPlayerPos = class_243.field_1353;
    private boolean updateRenderMap = false;
    private final Position2dToIntMap heightMap = new Position2dToIntMap(Integer.MIN_VALUE);
    private Future<AsyncComputationResult> asyncComputationFuture = null;
    private boolean heightMapDirty = false;
    private boolean selectedGizmo = false;
    private final int[] brushShape = new int[]{0};
    private final int[] radius = new int[]{4};
    private final GenericRadiusAdjustment radiusAdjustment = new GenericRadiusAdjustment(64);
    private final int[] placeMode = new int[]{0};
    private final int[] stampDirection = new int[]{0};
    private final float[] baseChance = new float[]{1.0f};
    private final int[] minSpacingPercentage = new int[]{100};
    private boolean randomYaw = true;
    private boolean randomXZFlip = true;
    private boolean keepExisting = false;
    private boolean extendFoundationToGround = false;
    private final List<ClipboardObject> blueprints = new ArrayList<ClipboardObject>();
    private final List<TransformedBlockRegions> transformedBlueprints = new ArrayList<TransformedBlockRegions>();
    private final List<StampBlueprintConfig> blueprintSettings = new ArrayList<StampBlueprintConfig>();
    private final Map<String, class_2338> savedOffsets = new HashMap<String, class_2338>();
    private class_2350 currentDirection = class_2350.field_11036;
    private final PresetWidget presetWidget = new PresetWidget(this, "stamp");
    private boolean settingsChanged = false;

    @Override
    public void reset() {
        this.partialReset();
        this.renderMap.clear();
        this.intermediatePlacements.clear();
        this.selectedGizmo = false;
    }

    @Override
    public void toolDeselected() {
        BlueprintBrowserWindow.resetCallback();
    }

    private void partialReset() {
        this.usingTool = false;
        this.brushPlacements.clear();
        this.stampBlocksPreview.clear();
        if (this.asyncComputationFuture != null) {
            this.asyncComputationFuture.cancel(true);
            this.asyncComputationFuture = null;
        }
        this.heightMap.clear();
        this.heightMapDirty = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.partialReset();
                switch (this.stampDirection[0]) {
                    case 0: {
                        this.currentDirection = class_2350.field_11036;
                        break;
                    }
                    case 1: {
                        this.currentDirection = class_2350.field_11033;
                        break;
                    }
                    case 2: {
                        this.currentDirection = class_2350.field_11043;
                        break;
                    }
                    case 3: {
                        this.currentDirection = class_2350.field_11034;
                        break;
                    }
                    case 4: {
                        this.currentDirection = class_2350.field_11035;
                        break;
                    }
                    case 5: {
                        this.currentDirection = class_2350.field_11039;
                    }
                }
                if (!this.blueprints.isEmpty()) {
                    this.usingTool = true;
                    this.toolPather = new ToolPatherSurface(this.radius[0], BallShape.getByIndex((int)this.brushShape[0]), MaskManager.getSourceMask(), this.currentDirection);
                }
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    intermediatePlacement.gizmo.enableAxes = false;
                }
                this.selectedGizmo = false;
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    if (!intermediatePlacement.gizmo.enableAxes || !intermediatePlacement.gizmo.leftClick()) continue;
                    this.selectedGizmo = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                Gizmo disableExcept = null;
                for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                    if (intermediate.gizmo.enableAxes || !intermediate.gizmo.leftClick()) continue;
                    this.selectedGizmo = true;
                    disableExcept = intermediate.gizmo;
                    break;
                }
                if (disableExcept != null) {
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        if (intermediate.gizmo == disableExcept) continue;
                        intermediate.gizmo.enableAxes = false;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!EditorUI.isCtrlOrCmdDown()) {
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.gizmo.enableAxes = false;
                    }
                    this.selectedGizmo = false;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ENTER: {
                if (this.brushPlacements.isEmpty() && this.intermediatePlacements.isEmpty()) break;
                ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                Long2ObjectOpenHashMap long2ObjectOpenHashMap = new Long2ObjectOpenHashMap();
                if (this.extendFoundationToGround) {
                    for (StampPlacement placement : this.brushPlacements) {
                        placement.pasteIntoExtendToGround(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)long2ObjectOpenHashMap, (class_1937)class_310.method_1551().field_1687);
                    }
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.placement.pasteIntoExtendToGround(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)long2ObjectOpenHashMap, (class_1937)class_310.method_1551().field_1687);
                    }
                } else {
                    for (StampPlacement placement : this.brushPlacements) {
                        placement.pasteInto(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)long2ObjectOpenHashMap);
                    }
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.placement.pasteInto(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)long2ObjectOpenHashMap);
                    }
                }
                int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                RegionHelper.pushBlockRegionChange(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)long2ObjectOpenHashMap, historyDescription, Tool.getSourceInfo(this), modifiers);
                this.reset();
                break;
            }
            case REDO: {
                if (!this.usingTool && this.intermediatePlacements.isEmpty()) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                boolean disabled = false;
                this.updateRenderMap = true;
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    if (!intermediatePlacement.gizmo.enableAxes) continue;
                    intermediatePlacement.gizmo.enableAxes = false;
                    disabled = true;
                }
                this.selectedGizmo = false;
                if (disabled) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.usingTool) {
                    this.partialReset();
                    this.updateRenderMap();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.intermediatePlacements.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: 
            case UNDO: {
                void var4_16;
                this.updateRenderMap = true;
                boolean removed = false;
                boolean bl = false;
                while (var4_16 < this.intermediatePlacements.size()) {
                    if (this.intermediatePlacements.get((int)var4_16).gizmo.enableAxes) {
                        this.intermediatePlacements.remove((int)var4_16);
                        --var4_16;
                        removed = true;
                    }
                    ++var4_16;
                }
                this.selectedGizmo = false;
                if (removed) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!this.usingTool && this.intermediatePlacements.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        block46: {
            float opacity;
            int maxPlacements;
            boolean placementMoved;
            boolean renderGizmos;
            boolean isCtrlDown;
            block45: {
                boolean showGizmo;
                if (this.blueprints.isEmpty() && this.intermediatePlacements.isEmpty()) {
                    Selection.render(camera, time, matrices, projection, 4);
                    return;
                }
                class_243 lookDirection = Tool.getLookDirection();
                boolean isLeftDown = Tool.isMouseDown(0);
                isCtrlDown = EditorUI.isCtrlOrCmdDown();
                renderGizmos = showGizmo = !isCtrlDown;
                boolean gizmoHovered = false;
                placementMoved = false;
                class_243 playerPos = class_310.method_1551().field_1724.method_33571();
                if (playerPos.method_1025(this.lastPlayerPos) > 1.0) {
                    this.lastPlayerPos = playerPos;
                    this.updateClosestGizmos(playerPos);
                }
                maxPlacements = Math.min(64, this.intermediatePlacements.size());
                for (int i = 0; i < maxPlacements; ++i) {
                    Object newTarget;
                    IntermediatePlacement intermediate2 = this.intermediatePlacements.get(i);
                    Gizmo gizmo = intermediate2.gizmo;
                    class_2338 previousTarget = gizmo.getTargetPosition();
                    gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
                    if (gizmo.enableAxes) {
                        int rotations;
                        Gizmo.GizmoRotation gizmoRotation;
                        gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
                        gizmoHovered = true;
                        this.selectedGizmo = true;
                        if (!gizmo.isGrabbed() && (gizmoRotation = gizmo.popRotation()) != null && (rotations = Math.round((float)Math.toDegrees(gizmoRotation.radians()) / 90.0f)) != 0) {
                            intermediate2.placement = intermediate2.placement.rotate(rotations);
                            placementMoved = true;
                        }
                    }
                    if (gizmo.isGrabbed()) {
                        renderGizmos = true;
                    }
                    if (gizmo.isHovered()) {
                        gizmoHovered = true;
                    }
                    if ((newTarget = gizmo.getTargetPosition()).equals((Object)previousTarget)) continue;
                    intermediate2.placement = intermediate2.placement.withBasePosition(newTarget.method_10263(), newTarget.method_10264(), newTarget.method_10260());
                    placementMoved = true;
                }
                opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                if (this.usingTool) break block45;
                RayCaster.RaycastResult result = Tool.raycastBlock();
                if (result == null) {
                    Selection.render(camera, time, matrices, projection, this.intermediatePlacements.isEmpty() ? 7 : 4);
                } else if (!gizmoHovered) {
                    int radius = this.radius[0];
                    int brushShape = this.brushShape[0];
                    if (this.oldRadius != radius || this.oldBrushShape != brushShape) {
                        this.oldRadius = radius;
                        this.oldBrushShape = brushShape;
                        this.previewSphere.clear();
                        BallShape.getByIndex((int)brushShape).fillRegion((BooleanRegion)this.previewSphere, radius);
                    }
                    Selection.render(camera, time, matrices, projection, 4);
                    this.previewSphere.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 1);
                }
                if (placementMoved || this.updateRenderMap) {
                    this.updateRenderMap();
                }
                for (Map.Entry<ChunkedBlockRegion, List<class_243>> entry : this.renderMap.entrySet()) {
                    for (class_243 offset : entry.getValue()) {
                        entry.getKey().render(camera, offset, matrices, projection, 1.0f, 0.15f - opacity * 0.1f);
                    }
                }
                if (!renderGizmos) break block46;
                maxPlacements = Math.min(64, this.intermediatePlacements.size());
                for (int i = 0; i < maxPlacements; ++i) {
                    IntermediatePlacement intermediate3 = this.intermediatePlacements.get(i);
                    intermediate3.gizmo.render(matrices, camera, isCtrlDown);
                }
                break block46;
            }
            if (Tool.cancelUsing()) {
                this.partialReset();
                this.updateRenderMap();
            } else if (!Tool.isMouseDown(1)) {
                if (this.placeMode[0] == 0) {
                    ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                    Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
                    if (this.extendFoundationToGround) {
                        for (StampPlacement placement : this.brushPlacements) {
                            placement.pasteIntoExtendToGround(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, (class_1937)class_310.method_1551().field_1687);
                        }
                    } else {
                        for (StampPlacement placement : this.brushPlacements) {
                            placement.pasteInto(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities);
                        }
                    }
                    int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                    String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
                    String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                    RegionHelper.pushBlockRegionChange(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, historyDescription, Tool.getSourceInfo(this), modifiers);
                    this.reset();
                } else {
                    for (StampPlacement placement : this.brushPlacements) {
                        Gizmo gizmo = new Gizmo(new class_2338(placement.baseX(), placement.baseY(), placement.baseZ()));
                        gizmo.enableAxes = false;
                        gizmo.enableRotation = true;
                        gizmo.yAxisRotationOnly = true;
                        this.intermediatePlacements.add(new IntermediatePlacement(gizmo, placement));
                    }
                    this.partialReset();
                    this.updateClosestGizmos(class_310.method_1551().field_1724.method_33571());
                }
            } else {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    return;
                }
                Selection.render(camera, time, matrices, projection, 4);
                WhiteNoise whiteNoise = new WhiteNoise(428362042L);
                int surfaceDirection = this.currentDirection.method_10171() == class_2350.class_2352.field_11060 ? -1 : 1;
                class_2335 axisCycle = class_2335.method_10057((class_2350.class_2351)this.currentDirection.method_10166(), (class_2350.class_2351)class_2350.class_2351.field_11052);
                this.heightMapDirty |= this.toolPather.update((x, y, z) -> {
                    this.stampBlocksPreview.add(x, y, z);
                    if ((double)this.baseChance[0] > 0.99 || whiteNoise.evaluate(x, z) < this.baseChance[0]) {
                        int a = axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11048);
                        int b = axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11052);
                        int c = axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11051);
                        this.heightMap.put(a, c, b + surfaceDirection);
                    }
                });
                boolean changed = false;
                if (this.asyncComputationFuture != null) {
                    if (this.asyncComputationFuture.isDone()) {
                        try {
                            AsyncComputationResult result = this.asyncComputationFuture.get();
                            this.brushPlacements.clear();
                            this.brushPlacements.addAll(result.newBrushPlacements);
                            this.intermediatePlacements.removeIf(intermediate -> {
                                StampPlacement placement = intermediate.placement;
                                return result.spacingBlacklistSet.contains(placement.baseX(), placement.baseZ());
                            });
                            changed = true;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        this.asyncComputationFuture = null;
                    }
                } else if (this.heightMapDirty) {
                    Position2dToIntMap heightMap = this.heightMap.copy();
                    int n = this.minSpacingPercentage[0];
                    ArrayList<StampBlueprintConfig> blueprintSettings = new ArrayList<StampBlueprintConfig>();
                    for (StampBlueprintConfig blueprintSetting : this.blueprintSettings) {
                        blueprintSettings.add(blueprintSetting.copy());
                    }
                    if (this.transformedBlueprints.size() < this.blueprints.size()) {
                        for (int i = this.transformedBlueprints.size(); i < this.blueprints.size(); ++i) {
                            this.transformedBlueprints.add(new TransformedBlockRegions(this.blueprints.get(i).blockRegion(), this.blueprints.get(i).blockEntities()));
                        }
                    } else if (this.transformedBlueprints.size() > this.blueprints.size()) {
                        int toRemove = this.transformedBlueprints.size() - this.blueprints.size();
                        for (int i = 0; i < toRemove; ++i) {
                            this.transformedBlueprints.remove(this.transformedBlueprints.size() - 1);
                        }
                    }
                    for (int i = 0; i < this.transformedBlueprints.size(); ++i) {
                        TransformedBlockRegions transformed = this.transformedBlueprints.get(i);
                        ChunkedBlockRegion blockRegion = this.blueprints.get(i).blockRegion();
                        if (transformed.getBlocks(0, false, false) == blockRegion) continue;
                        this.transformedBlueprints.set(i, new TransformedBlockRegions(blockRegion, this.blueprints.get(i).blockEntities()));
                    }
                    this.asyncComputationFuture = Tool.sharedSingleThreadExecutor.submit(() -> StampTool.update(heightMap, blueprintSettings, new ArrayList<TransformedBlockRegions>(this.transformedBlueprints), minSpacingPercentage, this.randomYaw, this.randomXZFlip, this.currentDirection));
                    this.heightMapDirty = false;
                }
                if (changed || placementMoved || this.updateRenderMap) {
                    this.updateRenderMap();
                }
                for (Map.Entry entry : this.renderMap.entrySet()) {
                    for (class_243 offset : (List)entry.getValue()) {
                        ((ChunkedBlockRegion)entry.getKey()).render(camera, offset, matrices, projection, 1.0f, 0.15f - opacity * 0.1f);
                    }
                }
                this.stampBlocksPreview.render(camera, class_243.field_1353, matrices, projection, time, 1);
                if (renderGizmos) {
                    maxPlacements = Math.min(64, this.intermediatePlacements.size());
                    for (int i = 0; i < maxPlacements; ++i) {
                        IntermediatePlacement intermediatePlacement = this.intermediatePlacements.get(i);
                        intermediatePlacement.gizmo.render(matrices, camera, isCtrlDown);
                    }
                }
            }
        }
    }

    private void updateClosestGizmos(class_243 playerPos) {
        this.intermediatePlacements.sort(Comparator.comparingDouble(intermediate -> {
            if (intermediate.gizmo.enableAxes) {
                return 0.0;
            }
            return intermediate.gizmo.getTargetPosition().method_19770((class_2374)playerPos);
        }));
    }

    private void updateRenderMap() {
        this.updateRenderMap = false;
        this.renderMap.clear();
        for (StampPlacement placement : this.brushPlacements) {
            this.renderMap.computeIfAbsent(placement.blockRegion(), k -> new ArrayList()).add(placement.getRenderOffset());
        }
        for (IntermediatePlacement intermediate : this.intermediatePlacements) {
            StampPlacement placement = intermediate.placement;
            this.renderMap.computeIfAbsent(placement.blockRegion(), k -> new ArrayList()).add(placement.getRenderOffset());
        }
    }

    private static AsyncComputationResult update(Position2dToIntMap heightMap, List<StampBlueprintConfig> blueprintSettings, List<TransformedBlockRegions> transformedBlueprints, int minSpacingPercentage, boolean randomYaw, boolean randomXZFlip, class_2350 direction) {
        class_2335 axisCycle = class_2335.method_10057((class_2350.class_2351)direction.method_10166(), (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2335 axisCycleInverse = axisCycle.method_10055();
        PositionalRandom positionalRandom = new PositionalRandom(0L, 0L);
        class_1923 chunkPos = heightMap.getLastChunk();
        int relA = chunkPos.field_9181 * 16 + 8;
        int relC = chunkPos.field_9180 * 16 + 8;
        LongArrayList positions = new LongArrayList();
        heightMap.forEachEntry((arg_0, arg_1, arg_2) -> StampTool.lambda$update$6(positionalRandom, relA, relC, (LongList)positions, arg_0, arg_1, arg_2));
        positions.unstableSort(null);
        Position2dSet spacingBlacklistSet = new Position2dSet();
        ArrayList<StampPlacement> newBrushPlacements = new ArrayList<StampPlacement>();
        float totalWeight = 0.0f;
        for (StampBlueprintConfig config : blueprintSettings) {
            totalWeight += config.chance()[0];
        }
        float invTotalWeight = 1.0f / totalWeight;
        for (int index = 0; index < positions.size(); ++index) {
            long pos = positions.getLong(index);
            int a = (short)(pos >>> 16 & 0xFFFFL) + relA;
            int c = (short)(pos & 0xFFFFL) + relC;
            int b = heightMap.get(a, c);
            if (spacingBlacklistSet.contains(a, c)) continue;
            positionalRandom.at(a, b, c);
            int blueprintIndex = -1;
            float blueprintFloat = positionalRandom.nextFloat();
            for (int i = 0; i < blueprintSettings.size(); ++i) {
                StampBlueprintConfig config = blueprintSettings.get(i);
                if (!((blueprintFloat -= config.chance()[0] * invTotalWeight) <= 0.0f)) continue;
                blueprintIndex = i;
                break;
            }
            if (blueprintIndex < 0) {
                blueprintIndex = blueprintSettings.size() - 1;
            }
            StampBlueprintConfig config = blueprintSettings.get(blueprintIndex);
            int rotation = randomYaw ? positionalRandom.nextInt(4) : 0;
            boolean flipX = randomXZFlip && positionalRandom.nextBoolean();
            boolean flipZ = !randomYaw && randomXZFlip && positionalRandom.nextBoolean();
            int x = axisCycleInverse.method_10056(a, b, c, class_2350.class_2351.field_11048);
            int y = axisCycleInverse.method_10056(a, b, c, class_2350.class_2351.field_11052);
            int z = axisCycleInverse.method_10056(a, b, c, class_2350.class_2351.field_11051);
            TransformedBlockRegions transformed = transformedBlueprints.get(blueprintIndex);
            ChunkedBlockRegion blockRegion = transformed.getBlocks(rotation, flipX, flipZ);
            int[] offset = new int[]{0, 0, 0};
            if (config.automaticOffset()[0]) {
                class_2338 min2 = blockRegion.min();
                class_2338 max2 = blockRegion.max();
                if (min2 != null && max2 != null) {
                    switch (direction) {
                        case field_11036: {
                            offset[1] = (min2.method_10264() + max2.method_10264()) / 2 - min2.method_10264();
                            break;
                        }
                        case field_11033: {
                            offset[1] = (min2.method_10264() + max2.method_10264()) / 2 - max2.method_10264();
                            break;
                        }
                        case field_11043: {
                            offset[2] = (min2.method_10260() + max2.method_10260()) / 2 - max2.method_10260();
                            break;
                        }
                        case field_11035: {
                            offset[2] = (min2.method_10260() + max2.method_10260()) / 2 - min2.method_10260();
                            break;
                        }
                        case field_11034: {
                            offset[0] = (min2.method_10263() + max2.method_10263()) / 2 - min2.method_10263();
                            break;
                        }
                        case field_11039: {
                            offset[0] = (min2.method_10263() + max2.method_10263()) / 2 - max2.method_10263();
                        }
                    }
                }
            } else {
                offset = config.offset();
            }
            StampPlacement stampPlacement = new StampPlacement(blockRegion, transformed.getBlockEntities(rotation, flipX, flipZ), transformed, rotation, flipX, flipZ, x + offset[0], y + offset[1], z + offset[2], x, y, z);
            newBrushPlacements.add(stampPlacement);
            float minSpacingA = 0.0f;
            float minSpacingC = 0.0f;
            ChunkedBlockRegion region = stampPlacement.blockRegion();
            class_2338 regionMin = region.min();
            class_2338 regionMax = region.max();
            if (regionMin != null && regionMax != null) {
                class_2338 size = regionMax.method_10059((class_2382)regionMin);
                int sizeA = axisCycle.method_10056(size.method_10263(), size.method_10264(), size.method_10260(), class_2350.class_2351.field_11048) + 1;
                int sizeC = axisCycle.method_10056(size.method_10263(), size.method_10264(), size.method_10260(), class_2350.class_2351.field_11051) + 1;
                minSpacingA = (float)(sizeA * minSpacingPercentage) / 100.0f * 1.414f;
                minSpacingC = (float)(sizeC * minSpacingPercentage) / 100.0f * 1.414f;
            }
            if (!(minSpacingA > 0.0f) || !(minSpacingC > 0.0f)) continue;
            int halfA = (int)Math.ceil(minSpacingA / 2.0f);
            int halfC = (int)Math.ceil(minSpacingC / 2.0f);
            for (int ao = -halfA; ao <= halfA; ++ao) {
                for (int co = -halfC; co <= halfC; ++co) {
                    float ar = (float)ao / (minSpacingA / 2.0f + 1.0f);
                    float cr = (float)co / (minSpacingC / 2.0f + 1.0f);
                    if (!(ar * ar + cr * cr <= 1.0f)) continue;
                    spacingBlacklistSet.add(a + ao, c + co);
                }
            }
        }
        return new AsyncComputationResult(spacingBlacklistSet, newBrushPlacements);
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.generic.brush_shape"), this.brushShape, BallShape.getAllNames());
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 0, 64);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp"));
        this.settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.stamp.base_chance"), this.baseChance, 0.001f, 1.0f, "%.3f", 32);
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.stamp.min_spacing"), this.minSpacingPercentage, 0, 800, "%d%%");
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.stamp.place"), this.placeMode, new String[]{AxiomI18n.get("axiom.tool.stamp.place_immediate"), AxiomI18n.get("axiom.tool.stamp.place_deferred")});
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.stamp.direction"), this.stampDirection, new String[]{"Top", "Bottom", "North", "East", "South", "West"});
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.smooth.modifiers"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.random_yaw"), this.randomYaw)) {
            this.randomYaw = !this.randomYaw;
            this.settingsChanged = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.random_xz_flip"), this.randomXZFlip)) {
            this.randomXZFlip = !this.randomXZFlip;
            this.settingsChanged = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp.paste_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            this.settingsChanged = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.extend_foundation_to_ground"), this.extendFoundationToGround)) {
            this.extendFoundationToGround = !this.extendFoundationToGround;
            this.settingsChanged = true;
        }
        ImGui.sameLine();
        ImGuiHelper.helpMarker(AxiomI18n.get("axiom.tool.stamp.extend_foundation_to_ground_tooltip"));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp.blueprints"));
        if (ImGui.button(AxiomI18n.get("axiom.tool.stamp.add_blueprint"))) {
            if (!Restrictions.canImportBlocks) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The server has disallowed the use of blueprints").method_27692(class_124.field_1061), false);
                }
            } else {
                Predicate<Blueprint> callback = blueprint -> {
                    if (!ToolManager.isToolActive() || ToolManager.getCurrentTool() != this) {
                        return false;
                    }
                    this.addBlueprint(new ClipboardObject.FromBlueprint((Blueprint)blueprint));
                    return true;
                };
                BlueprintBrowserWindow.open(callback, true);
            }
        }
        ImGui.sameLine();
        if (Clipboard.INSTANCE.isEmpty()) {
            ImGui.beginDisabled();
            ImGui.button("Add Clipboard");
            ImGui.endDisabled();
            ImGuiHelper.tooltip("Clipboard is empty", 512);
        } else if (ImGui.button("Add Clipboard")) {
            this.addBlueprint(Clipboard.INSTANCE.getClipboard());
        }
        ImGui.sameLine();
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.clipboard.clear"))) {
            this.blueprints.clear();
            this.blueprintSettings.clear();
            this.settingsChanged = true;
        }
        int removeIndex = -1;
        for (int i = 0; i < Math.min(this.blueprintSettings.size(), this.blueprints.size()); ++i) {
            ClipboardObject blueprint2 = this.blueprints.get(i);
            StampBlueprintConfig blueprintConfig = this.blueprintSettings.get(i);
            ImGui.imageButton(blueprint2.thumbnailTextureId(), 64.0f, 64.0f, 0.0f, 1.0f, 1.0f, 0.0f, 2);
            if (ImGui.isItemClicked(1)) {
                ImGui.openPopup("##EditBlueprint" + i);
            }
            if (ImGuiHelper.beginPopup("##EditBlueprint" + i)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.tool.path.remove"))) {
                    removeIndex = i;
                }
                if (ImGui.menuItem("Rotate Clockwise (X)")) {
                    this.blueprints.set(i, ClipboardObject.rotate(blueprint2, class_2350.class_2351.field_11048, -1));
                }
                if (ImGui.menuItem("Rotate Clockwise (Y)")) {
                    this.blueprints.set(i, ClipboardObject.rotate(blueprint2, class_2350.class_2351.field_11052, -1));
                }
                if (ImGui.menuItem("Rotate Clockwise (Z)")) {
                    this.blueprints.set(i, ClipboardObject.rotate(blueprint2, class_2350.class_2351.field_11051, -1));
                }
                if (ImGui.menuItem("Flip (X)")) {
                    this.blueprints.set(i, ClipboardObject.flip(blueprint2, class_2350.class_2351.field_11048));
                }
                if (ImGui.menuItem("Flip (Y)")) {
                    this.blueprints.set(i, ClipboardObject.flip(blueprint2, class_2350.class_2351.field_11052));
                }
                if (ImGui.menuItem("Flip (Z)")) {
                    this.blueprints.set(i, ClipboardObject.flip(blueprint2, class_2350.class_2351.field_11051));
                }
                ImGui.endPopup();
            }
            ImGui.sameLine();
            ImGui.beginGroup();
            String name = blueprint2.name();
            boolean blankName = name.isBlank();
            String displayName = !blankName ? name : AxiomI18n.get("axiom.editorui.window.blueprint_browser.unnamed_blueprint");
            String formattedCount = NumberFormat.getNumberInstance().format(blueprint2.blockRegion().count());
            String blockCount = AxiomI18n.get("axiom.editorui.window.clipboard.n_blocks", formattedCount);
            ImGui.text(displayName + " (" + blockCount + ")");
            if (blueprintConfig.automaticOffset()[0]) {
                if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.automatic_offset"), true)) {
                    blueprintConfig.automaticOffset()[0] = false;
                    class_2338 min2 = blueprint2.blockRegion().min();
                    class_2338 max2 = blueprint2.blockRegion().max();
                    if (min2 != null && max2 != null) {
                        Arrays.fill(blueprintConfig.offset(), 0);
                        switch (this.stampDirection[0]) {
                            case 0: {
                                blueprintConfig.offset()[1] = (min2.method_10264() + max2.method_10264()) / 2 - min2.method_10264();
                                break;
                            }
                            case 1: {
                                blueprintConfig.offset()[1] = (min2.method_10264() + max2.method_10264()) / 2 - max2.method_10264();
                                break;
                            }
                            case 2: {
                                blueprintConfig.offset()[2] = (min2.method_10260() + max2.method_10260()) / 2 - max2.method_10260();
                                break;
                            }
                            case 4: {
                                blueprintConfig.offset()[2] = (min2.method_10260() + max2.method_10260()) / 2 - min2.method_10260();
                                break;
                            }
                            case 3: {
                                blueprintConfig.offset()[0] = (min2.method_10263() + max2.method_10263()) / 2 - min2.method_10263();
                                break;
                            }
                            case 5: {
                                blueprintConfig.offset()[0] = (min2.method_10263() + max2.method_10263()) / 2 - max2.method_10263();
                            }
                        }
                    }
                }
            } else if (ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.stamp.offset") + "##" + i, blueprintConfig.offset(), true)) {
                if (!blankName) {
                    this.savedOffsets.put(name, new class_2338(blueprintConfig.offset()[0], blueprintConfig.offset()[1], blueprintConfig.offset()[2]));
                }
                this.settingsChanged = true;
            }
            ImGui.setNextItemWidth(ImGui.calcItemWidth() - (ImGui.getCursorPosX() - ImGui.getStyle().getWindowPaddingX()) * 2.0f / 3.0f);
            this.settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.stamp.chance") + "##" + i, blueprintConfig.chance(), 0.0f, 100.0f, "%.1f%%");
            ImGui.endGroup();
        }
        if (removeIndex >= 0) {
            this.blueprints.remove(removeIndex);
            this.blueprintSettings.remove(removeIndex);
            this.settingsChanged = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(this.settingsChanged);
        this.settingsChanged = false;
    }

    private void addBlueprint(ClipboardObject blueprint) {
        float newChance;
        float total = 0.0f;
        for (StampBlueprintConfig config : this.blueprintSettings) {
            total += config.chance()[0];
        }
        if (total < 100.0f) {
            newChance = 100.0f - total;
        } else {
            float factor = (float)this.blueprintSettings.size() / (float)(this.blueprintSettings.size() + 1);
            for (StampBlueprintConfig config : this.blueprintSettings) {
                float[] fArray = config.chance();
                fArray[0] = fArray[0] * factor;
            }
            newChance = 100.0f / (float)(this.blueprintSettings.size() + 1);
        }
        int[] offset = new int[3];
        boolean[] automaticOffset = new boolean[]{true};
        String name = blueprint.name();
        if (!name.isBlank() && this.savedOffsets.containsKey(name)) {
            class_2338 savedOffset = this.savedOffsets.get(name);
            offset[0] = savedOffset.method_10263();
            offset[1] = savedOffset.method_10264();
            offset[2] = savedOffset.method_10260();
            automaticOffset[0] = false;
        } else {
            class_2338 min2 = blueprint.blockRegion().min();
            class_2338 max2 = blueprint.blockRegion().max();
            if (min2 != null && max2 != null) {
                switch (this.stampDirection[0]) {
                    case 0: {
                        offset[1] = (min2.method_10264() + max2.method_10264()) / 2 - min2.method_10264();
                        break;
                    }
                    case 1: {
                        offset[1] = (min2.method_10264() + max2.method_10264()) / 2 - max2.method_10264();
                        break;
                    }
                    case 2: {
                        offset[2] = (min2.method_10260() + max2.method_10260()) / 2 - max2.method_10260();
                        break;
                    }
                    case 4: {
                        offset[2] = (min2.method_10260() + max2.method_10260()) / 2 - min2.method_10260();
                        break;
                    }
                    case 3: {
                        offset[0] = (min2.method_10263() + max2.method_10263()) / 2 - min2.method_10263();
                        break;
                    }
                    case 5: {
                        offset[0] = (min2.method_10263() + max2.method_10263()) / 2 - max2.method_10263();
                    }
                }
            }
        }
        this.blueprints.add(blueprint);
        this.blueprintSettings.add(new StampBlueprintConfig(automaticOffset, offset, new float[]{newChance}));
        this.settingsChanged = true;
    }

    @Override
    public String listenForEsc() {
        if (!this.intermediatePlacements.isEmpty() && this.selectedGizmo) {
            return "Deselect Gizmo";
        }
        if (this.usingTool || !this.intermediatePlacements.isEmpty()) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public boolean initiateAdjustment() {
        return this.radiusAdjustment.initiateAdjustment(this.radius[0], -1);
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        GenericRadiusAdjustment.Result result = this.radiusAdjustment.renderAdjustment(mouseX, mouseY, mouseDelta);
        this.radius[0] = result.radius();
        return result.mouseDelta();
    }

    @Override
    public String listenForEnter() {
        if (!this.brushPlacements.isEmpty() || !this.intermediatePlacements.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.stamp");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Stamp Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettingsWithoutBlockData(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    public void writeSettingsWithoutBlockData(class_2487 tag) {
        tag.method_10567("BrushShape", (byte)this.brushShape[0]);
        tag.method_10569("BrushRadius", this.radius[0]);
        tag.method_10569("PlaceMode", this.placeMode[0]);
        tag.method_10548("BaseChance", this.baseChance[0]);
        tag.method_10569("MinSpacingPercentage", this.minSpacingPercentage[0]);
        tag.method_10556("RandomYaw", this.randomYaw);
        tag.method_10556("RandomXZFlip", this.randomXZFlip);
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.writeSettingsWithoutBlockData(tag);
        class_2499 blueprintsTag = new class_2499();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < this.blueprints.size(); ++i) {
            baos.reset();
            ClipboardObject blueprint = this.blueprints.get(i);
            StampBlueprintConfig blueprintConfig = this.blueprintSettings.get(i);
            try {
                BlueprintHeader header;
                class_1011 image;
                class_2487 stampBlueprint = new class_2487();
                if (blueprint instanceof ClipboardObject.FromBlueprint) {
                    ClipboardObject.FromBlueprint fromBlueprint = (ClipboardObject.FromBlueprint)blueprint;
                    image = fromBlueprint.blueprint().thumbnail().method_4525();
                    header = fromBlueprint.blueprint().header();
                } else {
                    if (blueprint instanceof ClipboardObject.Anonymous) {
                        ClipboardObject.Anonymous anonymous = (ClipboardObject.Anonymous)blueprint;
                        image = anonymous.texture == null ? null : anonymous.texture.method_4525();
                    } else {
                        image = null;
                    }
                    header = new BlueprintHeader(blueprint.name(), "", new ArrayList<String>(), 0.0f, 0.0f, false, blueprint.blockRegion().count(), blueprint.containsAir());
                }
                boolean closeNativeImage = false;
                if (image == null) {
                    image = new class_1011(96, 96, true);
                    closeNativeImage = true;
                }
                BlueprintIo.write(baos, header, image, blueprint.blockRegion(), (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), List.of());
                stampBlueprint.method_10570("Blueprint", baos.toByteArray());
                stampBlueprint.method_10556("AutomaticOffset", blueprintConfig.automaticOffset()[0]);
                stampBlueprint.method_10569("OffsetX", blueprintConfig.offset()[0]);
                stampBlueprint.method_10569("OffsetY", blueprintConfig.offset()[1]);
                stampBlueprint.method_10569("OffsetZ", blueprintConfig.offset()[2]);
                stampBlueprint.method_10548("Chance", blueprintConfig.chance()[0]);
                blueprintsTag.add((Object)stampBlueprint);
                if (!closeNativeImage) continue;
                image.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tag.method_10566("Blueprints", (class_2520)blueprintsTag);
    }

    public void clearBlueprints() {
        this.blueprints.clear();
        this.blueprintSettings.clear();
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushShape[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "BrushShape", 0);
        this.radius[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "BrushRadius", 4);
        this.placeMode[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "PlaceMode", 0);
        this.baseChance[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "BaseChance", 1.0f);
        this.minSpacingPercentage[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "MinSpacingPercentage", 100);
        this.randomYaw = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "RandomYaw", true);
        this.randomXZFlip = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "RandomXZFlip", true);
        this.clearBlueprints();
        if (Restrictions.canImportBlocks) {
            class_2499 blueprintsTag = NbtHelper.getList(tag, "Blueprints", 10);
            for (class_2520 blueprintTag : blueprintsTag) {
                class_2487 blueprint = (class_2487)blueprintTag;
                try {
                    byte[] blueprintData = VersionUtilsNbt.helperCompoundTagGetByteArray(blueprint, "Blueprint").orElse(null);
                    Blueprint fullBlueprint = BlueprintIo.readBlueprint(new ByteArrayInputStream(blueprintData));
                    boolean[] automaticOffset = new boolean[]{VersionUtilsNbt.helperCompoundTagGetBooleanOr(blueprint, "AutomaticOffset", false)};
                    int[] offset = new int[]{VersionUtilsNbt.helperCompoundTagGetIntOr(blueprint, "OffsetX", 0), VersionUtilsNbt.helperCompoundTagGetIntOr(blueprint, "OffsetY", 0), VersionUtilsNbt.helperCompoundTagGetIntOr(blueprint, "OffsetZ", 0)};
                    float chance = VersionUtilsNbt.helperCompoundTagGetFloatOr(blueprint, "Chance", 0.0f);
                    this.blueprints.add(new ClipboardObject.FromBlueprint(fullBlueprint));
                    this.blueprintSettings.add(new StampBlueprintConfig(automaticOffset, offset, new float[]{chance}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public char iconChar() {
        return '\ue91b';
    }

    @Override
    public String keybindId() {
        return "stamp";
    }

    private static /* synthetic */ void lambda$update$6(PositionalRandom positionalRandom, int relA, int relC, LongList positions, int a, int c, int b) {
        positionalRandom.at(c, a, b);
        int weight = positionalRandom.nextInt();
        long position = ((long)weight & 0xFFFFFFFFL) << 32 | ((long)((short)(a - relA)) & 0xFFFFL) << 16 | (long)((short)(c - relC)) & 0xFFFFL;
        positions.add(position);
    }

    record AsyncComputationResult(Position2dSet spacingBlacklistSet, List<StampPlacement> newBrushPlacements) {
    }
}

