/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.shape;

import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class TerrainDistanceField {
    private static final float SQRT_2 = (float)Math.sqrt(2.0);
    private static final float SQRT_3 = (float)Math.sqrt(3.0);

    public static void calculateChamferEuclideanTwo(TriIntPredicate first, TriIntPredicate second, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, TwoDistanceConsumer consumer) {
        int index;
        int z;
        int y;
        int x;
        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;
        float[] distancesOne = new float[(sizeX + 2) * (sizeY + 2) * (sizeZ + 2)];
        Arrays.fill(distancesOne, Float.POSITIVE_INFINITY);
        float[] distancesTwo = new float[(sizeX + 2) * (sizeY + 2) * (sizeZ + 2)];
        Arrays.fill(distancesTwo, Float.POSITIVE_INFINITY);
        int xIndexOffset = (sizeY + 2) * (sizeZ + 2);
        int yIndexOffset = sizeZ + 2;
        int zIndexOffset = 1;
        for (x = 0; x < sizeX; ++x) {
            for (y = 0; y < sizeY; ++y) {
                for (z = 0; z < sizeZ; ++z) {
                    float least;
                    index = (x + 1) * xIndexOffset + (y + 1) * yIndexOffset + (z + 1) * zIndexOffset;
                    if (first.test(minX + x, minY + y, minZ + z)) {
                        distancesOne[index] = 0.0f;
                    } else {
                        least = Float.POSITIVE_INFINITY;
                        least = Math.min(least, distancesOne[index - xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                        least = Math.min(least, distancesOne[index - xIndexOffset - yIndexOffset] + SQRT_2);
                        least = Math.min(least, distancesOne[index - xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                        least = Math.min(least, distancesOne[index - xIndexOffset - zIndexOffset] + SQRT_2);
                        least = Math.min(least, distancesOne[index - xIndexOffset] + 1.0f);
                        least = Math.min(least, distancesOne[index - xIndexOffset + zIndexOffset] + SQRT_2);
                        least = Math.min(least, distancesOne[index - xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                        least = Math.min(least, distancesOne[index - xIndexOffset + yIndexOffset] + SQRT_2);
                        least = Math.min(least, distancesOne[index - xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                        least = Math.min(least, distancesOne[index - yIndexOffset - zIndexOffset] + SQRT_2);
                        least = Math.min(least, distancesOne[index - yIndexOffset] + 1.0f);
                        least = Math.min(least, distancesOne[index - yIndexOffset + zIndexOffset] + SQRT_2);
                        distancesOne[index] = least = Math.min(least, distancesOne[index - zIndexOffset] + 1.0f);
                    }
                    if (second.test(minX + x, minY + y, minZ + z)) {
                        distancesTwo[index] = 0.0f;
                        continue;
                    }
                    least = Float.POSITIVE_INFINITY;
                    least = Math.min(least, distancesTwo[index - xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distancesTwo[index - xIndexOffset - yIndexOffset] + SQRT_2);
                    least = Math.min(least, distancesTwo[index - xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distancesTwo[index - xIndexOffset - zIndexOffset] + SQRT_2);
                    least = Math.min(least, distancesTwo[index - xIndexOffset] + 1.0f);
                    least = Math.min(least, distancesTwo[index - xIndexOffset + zIndexOffset] + SQRT_2);
                    least = Math.min(least, distancesTwo[index - xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distancesTwo[index - xIndexOffset + yIndexOffset] + SQRT_2);
                    least = Math.min(least, distancesTwo[index - xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distancesTwo[index - yIndexOffset - zIndexOffset] + SQRT_2);
                    least = Math.min(least, distancesTwo[index - yIndexOffset] + 1.0f);
                    least = Math.min(least, distancesTwo[index - yIndexOffset + zIndexOffset] + SQRT_2);
                    distancesTwo[index] = least = Math.min(least, distancesTwo[index - zIndexOffset] + 1.0f);
                }
            }
        }
        for (x = sizeX - 1; x >= 0; --x) {
            for (y = sizeY - 1; y >= 0; --y) {
                for (z = sizeZ - 1; z >= 0; --z) {
                    index = (x + 1) * xIndexOffset + (y + 1) * yIndexOffset + (z + 1) * zIndexOffset;
                    float leastOne = distancesOne[index];
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset + yIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset + zIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset] + 1.0f);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset - zIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset - yIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                    leastOne = Math.min(leastOne, distancesOne[index + yIndexOffset + zIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + yIndexOffset] + 1.0f);
                    leastOne = Math.min(leastOne, distancesOne[index + yIndexOffset - zIndexOffset] + SQRT_2);
                    leastOne = Math.min(leastOne, distancesOne[index + zIndexOffset] + 1.0f);
                    float leastTwo = distancesTwo[index];
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset + yIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset + zIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset] + 1.0f);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset - zIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset - yIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + yIndexOffset + zIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + yIndexOffset] + 1.0f);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + yIndexOffset - zIndexOffset] + SQRT_2);
                    leastTwo = Math.min(leastTwo, distancesTwo[index + zIndexOffset] + 1.0f);
                    consumer.accept(minX + x, minY + y, minZ + z, leastOne, leastTwo);
                    distancesOne[index] = leastOne;
                    distancesTwo[index] = leastTwo;
                }
            }
        }
    }

    public static float[] calculateChamferEuclidean(class_1937 level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int index;
        int z;
        int y;
        int x;
        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;
        float[] distances = new float[(sizeX + 2) * (sizeY + 2) * (sizeZ + 2)];
        Arrays.fill(distances, Float.POSITIVE_INFINITY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int xIndexOffset = (sizeY + 2) * (sizeZ + 2);
        int yIndexOffset = sizeZ + 2;
        int zIndexOffset = 1;
        for (x = 0; x < sizeX; ++x) {
            for (y = 0; y < sizeY; ++y) {
                for (z = 0; z < sizeZ; ++z) {
                    index = (x + 1) * xIndexOffset + (y + 1) * yIndexOffset + (z + 1) * zIndexOffset;
                    mutableBlockPos.method_10103(minX + x, minY + y, minZ + z);
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                    if (blockState.method_51366()) {
                        distances[index] = 0.0f;
                        continue;
                    }
                    float least = Float.POSITIVE_INFINITY;
                    least = Math.min(least, distances[index - xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index - xIndexOffset - yIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index - xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index - xIndexOffset - zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index - xIndexOffset] + 1.0f);
                    least = Math.min(least, distances[index - xIndexOffset + zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index - xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index - xIndexOffset + yIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index - xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index - yIndexOffset - zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index - yIndexOffset] + 1.0f);
                    least = Math.min(least, distances[index - yIndexOffset + zIndexOffset] + SQRT_2);
                    distances[index] = least = Math.min(least, distances[index - zIndexOffset] + 1.0f);
                }
            }
        }
        for (x = sizeX - 1; x >= 0; --x) {
            for (y = sizeY - 1; y >= 0; --y) {
                for (z = sizeZ - 1; z >= 0; --z) {
                    index = (x + 1) * xIndexOffset + (y + 1) * yIndexOffset + (z + 1) * zIndexOffset;
                    float least = distances[index];
                    least = Math.min(least, distances[index + xIndexOffset + yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index + xIndexOffset + yIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index + xIndexOffset + yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index + xIndexOffset + zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index + xIndexOffset] + 1.0f);
                    least = Math.min(least, distances[index + xIndexOffset - zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index + xIndexOffset - yIndexOffset + zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index + xIndexOffset - yIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index + xIndexOffset - yIndexOffset - zIndexOffset] + SQRT_3);
                    least = Math.min(least, distances[index + yIndexOffset + zIndexOffset] + SQRT_2);
                    least = Math.min(least, distances[index + yIndexOffset] + 1.0f);
                    least = Math.min(least, distances[index + yIndexOffset - zIndexOffset] + SQRT_2);
                    distances[index] = least = Math.min(least, distances[index + zIndexOffset] + 1.0f);
                }
            }
        }
        return distances;
    }

    @FunctionalInterface
    public static interface TwoDistanceConsumer {
        public void accept(int var1, int var2, int var3, float var4, float var5);
    }
}

