/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.cache;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.BufferBuilderExt;
import com.moulberry.axiom.render.BlockTessellator;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_9801;
import org.lwjgl.system.MemoryUtil;

public class TessellatedBlockCache {
    private static final MemoryUtil.MemoryAllocator ALLOCATOR = MemoryUtil.getAllocator((boolean)false);
    private class_2680 blockState = class_2246.field_10124.method_9564();
    private final class_5819 rand = class_5819.method_43047();
    private final class_4587 emptyPoseStack = new class_4587();
    private final VertexConsumerProvider provider = VertexConsumerProvider.owned(1024);
    private final BlockTessellator blockTessellator = new BlockTessellator();
    private final Int2LongOpenHashMap offsets = new Int2LongOpenHashMap();
    private final Int2LongOpenHashMap liquidPositionDelta = new Int2LongOpenHashMap();
    private ByteBuffer vertexInformation;
    private class_293 format = null;
    private int formatStride = 0;
    private int formatPositionOffset = 0;
    private List<Object> reusableList;

    public TessellatedBlockCache() {
        long pointer = ALLOCATOR.malloc(1024L);
        if (pointer == 0L) {
            throw new OutOfMemoryError("Failed to allocate 1024 bytes");
        }
        this.vertexInformation = MemoryUtil.memByteBuffer((long)pointer, (int)1024);
    }

    public void clear() {
        this.offsets.clear();
        this.liquidPositionDelta.clear();
        this.vertexInformation.clear();
        this.format = null;
        this.formatStride = 0;
        this.formatPositionOffset = 0;
    }

    public void setBlockState(class_2680 blockState) {
        if (this.blockState != blockState) {
            this.blockState = blockState;
            this.clear();
        }
    }

    public void close() {
        long address = MemoryUtil.memAddress0((Buffer)this.vertexInformation);
        this.vertexInformation = null;
        if (address != 0L) {
            ALLOCATOR.free(address);
        }
        this.provider.close();
    }

    public void setVertexFormat(class_293 vertexFormat) {
        class_296 element;
        if (this.format == vertexFormat) {
            return;
        }
        this.clear();
        this.format = vertexFormat;
        this.formatStride = this.format.method_1362();
        this.formatPositionOffset = 0;
        Iterator iterator = this.format.method_1357().iterator();
        while (iterator.hasNext() && ((element = (class_296)iterator.next()).comp_2845() != class_296.class_298.field_1633 || element.comp_2844() != class_296.class_297.field_1623 || element.comp_2846() != 3)) {
            this.formatPositionOffset += element.method_60847();
        }
        if (this.formatPositionOffset >= this.formatStride) {
            this.formatPositionOffset = -1;
        }
    }

    public void renderBlock(class_287 blockBuilder, class_776 renderManager, ChunkedBlockRegion region, class_2338 blockPos, int x, int y, int z) {
        int vertexCount;
        int position;
        int wx = blockPos.method_10263();
        int wy = blockPos.method_10264();
        int wz = blockPos.method_10260();
        int neighborInfo = 0;
        if (region.getBlockStateOrNull(wx, wy, wz - 1) != null) {
            neighborInfo |= 0x20;
        }
        if (region.getBlockStateOrNull(wx, wy - 1, wz) != null) {
            neighborInfo |= 0x800;
        }
        if (region.getBlockStateOrNull(wx - 1, wy, wz) != null) {
            neighborInfo |= 0x2000;
        }
        if (region.getBlockStateOrNull(wx + 1, wy, wz) != null) {
            neighborInfo |= 0x8000;
        }
        if (region.getBlockStateOrNull(wx, wy + 1, wz) != null) {
            neighborInfo |= 0x20000;
        }
        if (region.getBlockStateOrNull(wx, wy, wz + 1) != null) {
            neighborInfo |= 0x800000;
        }
        if (neighborInfo != 8562720) {
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz - 1) != null) {
                neighborInfo |= 2;
            }
            if (region.getBlockStateOrNull(wx, wy - 1, wz - 1) != null) {
                neighborInfo |= 4;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz - 1) != null) {
                neighborInfo |= 8;
            }
            if (region.getBlockStateOrNull(wx - 1, wy, wz - 1) != null) {
                neighborInfo |= 0x10;
            }
            if (region.getBlockStateOrNull(wx + 1, wy, wz - 1) != null) {
                neighborInfo |= 0x40;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x80;
            }
            if (region.getBlockStateOrNull(wx, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x100;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x200;
            }
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz) != null) {
                neighborInfo |= 0x400;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz) != null) {
                neighborInfo |= 0x1000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz) != null) {
                neighborInfo |= 0x10000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz) != null) {
                neighborInfo |= 0x40000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x80000;
            }
            if (region.getBlockStateOrNull(wx, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x100000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x200000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy, wz + 1) != null) {
                neighborInfo |= 0x400000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy, wz + 1) != null) {
                neighborInfo |= 0x1000000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x2000000;
            }
            if (region.getBlockStateOrNull(wx, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x4000000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x8000000;
            }
        }
        if (!this.offsets.containsKey(neighborInfo)) {
            class_9801 buffer;
            class_287 builder = this.provider.begin(class_293.class_5596.field_27382, AxiomVertexFormats.AXIOM_BLOCK);
            this.blockTessellator.tessellateBlock(renderManager, this.blockState, region, blockPos, builder, this.rand, this.emptyPoseStack);
            class_3610 fluid = this.blockState.method_26227();
            if (!fluid.method_15769()) {
                renderManager.method_3352(blockPos, (class_1920)region, (class_4588)builder, this.blockState, fluid);
                this.liquidPositionDelta.put(neighborInfo, class_2338.method_10064((int)(blockPos.method_10263() & 0xF), (int)(blockPos.method_10264() & 0xF), (int)(blockPos.method_10260() & 0xF)));
            }
            if ((buffer = this.provider.build()) == null) {
                this.offsets.put(neighborInfo, 0L);
                position = 0;
                vertexCount = 0;
            } else {
                ByteBuffer data = buffer.method_60818();
                if (data.limit() % this.formatStride != 0) {
                    throw new FaultyImplementationError();
                }
                int needed = this.vertexInformation.position() + data.limit() + this.formatStride;
                if (needed >= this.vertexInformation.capacity()) {
                    int newCapacity = class_3532.method_15339((int)needed);
                    long l = ALLOCATOR.realloc(MemoryUtil.memAddress0((Buffer)this.vertexInformation), (long)newCapacity);
                    if (l == 0L) {
                        throw new OutOfMemoryError("Failed to resize buffer from " + this.vertexInformation.capacity() + " bytes to " + newCapacity + " bytes");
                    }
                    ByteBuffer newBuffer = MemoryUtil.memByteBuffer((long)l, (int)newCapacity);
                    newBuffer.position(this.vertexInformation.position());
                    this.vertexInformation = newBuffer;
                }
                MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)data), (long)MemoryUtil.memAddress((ByteBuffer)this.vertexInformation), (long)data.limit());
                position = this.vertexInformation.position();
                vertexCount = data.limit() / this.formatStride;
                long info = (long)position & 0xFFFFFFFFL | ((long)vertexCount & 0xFFFFFFFFL) << 32;
                this.offsets.put(neighborInfo, info);
                this.vertexInformation.position(this.vertexInformation.position() + data.limit());
                buffer.close();
            }
            this.provider.clear();
        } else {
            long info = this.offsets.get(neighborInfo);
            position = (int)(info & 0xFFFFFFFFL);
            vertexCount = (int)(info >>> 32 & 0xFFFFFFFFL);
        }
        if (vertexCount > 0) {
            int numBytes = vertexCount * this.formatStride;
            long ptr = ((BufferBuilderExt)blockBuilder).axiom$reserve(numBytes);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)this.vertexInformation, (int)position), (long)ptr, (long)numBytes);
            if (this.formatPositionOffset >= 0) {
                long liquidPositionDelta = this.liquidPositionDelta.getOrDefault(neighborInfo, 0L);
                x -= class_2338.method_10061((long)liquidPositionDelta);
                y -= class_2338.method_10071((long)liquidPositionDelta);
                z -= class_2338.method_10083((long)liquidPositionDelta);
                long addr = ptr + (long)this.formatPositionOffset;
                for (int i = 0; i < vertexCount; ++i) {
                    MemoryUtil.memPutFloat((long)addr, (float)(MemoryUtil.memGetFloat((long)addr) + (float)x));
                    MemoryUtil.memPutFloat((long)(addr + 4L), (float)(MemoryUtil.memGetFloat((long)(addr + 4L)) + (float)y));
                    MemoryUtil.memPutFloat((long)(addr + 8L), (float)(MemoryUtil.memGetFloat((long)(addr + 8L)) + (float)z));
                    addr += (long)this.formatStride;
                }
            }
            blockBuilder.field_1554 += vertexCount;
        }
    }
}

