/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SupersphereRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void supersphere(ChunkedBlockRegion region, class_2680 block, class_2338 center, int diameterX, int diameterY, int diameterZ, boolean hollow, float exponent, @Nullable Quaternionf quaternionf) {
        if (diameterX <= 0 || diameterY <= 0 || diameterZ <= 0) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusY = (float)(diameterY - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        int powLutSize = Math.max(maxRadiusX, Math.max(maxRadiusY, maxRadiusZ)) * 10 + 10;
        double[] powLookup = new double[powLutSize];
        for (int i = 0; i < powLookup.length; ++i) {
            powLookup[i] = Math.pow((float)i / 10.0f, exponent);
        }
        float invRadiusX = 1.0f / (float)Math.pow(radiusX + 0.5f, exponent);
        float invRadiusY = 1.0f / (float)Math.pow(radiusY + 0.5f, exponent);
        float invRadiusZ = 1.0f / (float)Math.pow(radiusZ + 0.5f, exponent);
        if (!Float.isFinite(invRadiusX)) {
            invRadiusX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invRadiusY)) {
            invRadiusY = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invRadiusZ)) {
            invRadiusZ = Float.MAX_VALUE;
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(radiusY % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block6: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    double rzPow;
                    double ryPow;
                    double rxPow;
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    int rxPowIndex = (int)Math.abs(rx * 10.0f);
                    int ryPowIndex = (int)Math.abs(ry * 10.0f);
                    int rzPowIndex = (int)Math.abs(rz * 10.0f);
                    if (rxPowIndex >= powLutSize || ryPowIndex >= powLutSize || rzPowIndex >= powLutSize || !((rxPow = powLookup[rxPowIndex]) * (double)invRadiusX + (ryPow = powLookup[ryPowIndex]) * (double)invRadiusY + (rzPow = powLookup[rzPowIndex]) * (double)invRadiusZ <= 1.0)) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        rxPowIndex = (int)Math.abs(rx * 10.0f);
                        ryPowIndex = (int)Math.abs(ry * 10.0f);
                        rzPowIndex = (int)Math.abs(rz * 10.0f);
                        if (rxPowIndex >= powLutSize || ryPowIndex >= powLutSize || rzPowIndex >= powLutSize) {
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue block6;
                        }
                        rxPow = powLookup[rxPowIndex];
                        ryPow = powLookup[ryPowIndex];
                        rzPow = powLookup[rzPowIndex];
                        if (!(rxPow * (double)invRadiusX + ryPow * (double)invRadiusY + rzPow * (double)invRadiusZ > 1.0)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block6;
                    }
                }
            }
        }
    }

    public static void supersphereMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, int diameterX, int diameterY, int diameterZ, boolean hollow, float exponent, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            SupersphereRasterization.supersphere(region, block, center, diameterX, diameterY, diameterZ, hollow, exponent, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (diameterX <= 0 || diameterY <= 0 || diameterZ <= 0) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        Quaternionf quaternionFinal = quaternionf;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusY = (float)(diameterY - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRadiusY = (int)Math.ceil(radiusY + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x2 = -1; x2 <= 1; x2 += 2) {
            for (int y2 = -1; y2 <= 1; y2 += 2) {
                for (int z2 = -1; z2 <= 1; z2 += 2) {
                    vector3f.set((float)(ceilRadiusX * x2), (float)(ceilRadiusY * y2), (float)(ceilRadiusZ * z2));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        int powLutSize = Math.max(maxRadiusX, Math.max(maxRadiusY, maxRadiusZ)) * 10;
        float[] powLookup = new float[powLutSize];
        for (int i = 0; i < powLookup.length; ++i) {
            powLookup[i] = (float)Math.pow((float)i / 10.0f, exponent);
        }
        float invRadiusX = RasterizationHelper.finiteOrMaxValue(1.0f / (float)Math.pow(radiusX + 0.5f, exponent));
        float invRadiusY = RasterizationHelper.finiteOrMaxValue(1.0f / (float)Math.pow(radiusY + 0.5f, exponent));
        float invRadiusZ = RasterizationHelper.finiteOrMaxValue(1.0f / (float)Math.pow(radiusZ + 0.5f, exponent));
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(radiusY % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        RasterizationHelper.metaball((class_1937)level, region, metaballRange, block, center, maxRadiusX, maxRadiusY, maxRadiusZ, (x, y, z) -> {
            vector3f.set((float)x, (float)y, (float)z);
            quaternionFinal.transform(vector3f);
            float rx = vector3f.x + offsetX;
            float ry = vector3f.y + offsetY;
            float rz = vector3f.z + offsetZ;
            int rxPowIndex = (int)Math.abs(rx * 10.0f);
            int ryPowIndex = (int)Math.abs(ry * 10.0f);
            int rzPowIndex = (int)Math.abs(rz * 10.0f);
            if (rxPowIndex >= powLutSize) {
                return false;
            }
            if (ryPowIndex >= powLutSize) {
                return false;
            }
            if (rzPowIndex >= powLutSize) {
                return false;
            }
            float rxPow = powLookup[rxPowIndex];
            float ryPow = powLookup[ryPowIndex];
            float rzPow = powLookup[rzPowIndex];
            if (rxPow * invRadiusX + ryPow * invRadiusY + rzPow * invRadiusZ <= 1.0f) {
                if (!hollow) {
                    return true;
                }
                for (int i = 0; i < 18; i += 3) {
                    int nx = x + CARDINAL_OFFSETS[i];
                    int ny = y + CARDINAL_OFFSETS[i + 1];
                    int nz = z + CARDINAL_OFFSETS[i + 2];
                    vector3f.set((float)nx, (float)ny, (float)nz);
                    quaternionFinal.transform(vector3f);
                    rx = vector3f.x + offsetX;
                    ry = vector3f.y + offsetY;
                    rz = vector3f.z + offsetZ;
                    rxPowIndex = (int)Math.abs(rx * 10.0f);
                    ryPowIndex = (int)Math.abs(ry * 10.0f);
                    rzPowIndex = (int)Math.abs(rz * 10.0f);
                    if (rxPowIndex >= powLutSize || ryPowIndex >= powLutSize || rzPowIndex >= powLutSize || !((rxPow = powLookup[rxPowIndex]) * invRadiusX + (ryPow = powLookup[ryPowIndex]) * invRadiusY + (rzPow = powLookup[rzPowIndex]) * invRadiusZ > 1.0f)) continue;
                    return true;
                }
            }
            return false;
        });
    }
}

