/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class RegularPolygonRasterization {
    public static void regularPolygon(Vector3i center, int diameterX, int diameterZ, boolean hollow, int vertices, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        if (vertices < 3) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        if (hollow) {
            float offsetX = radiusX % 1.0f + 0.5f;
            float offsetZ = radiusZ % 1.0f + 0.5f;
            Vector3f from = new Vector3f(offsetX, 0.5f, radiusZ + offsetZ);
            quaternionf.transformInverse(from);
            Vector3f to = new Vector3f();
            for (int a = 1; a <= vertices; ++a) {
                float currX = (float)Math.sin((double)a * Math.PI * 2.0 / (double)vertices) * (radiusX - 0.15f) + offsetX;
                float currZ = (float)Math.cos((double)a * Math.PI * 2.0 / (double)vertices) * (radiusZ - 0.15f) + offsetZ;
                to.set(currX, 0.5f, currZ);
                quaternionf.transformInverse(to);
                Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
                Vector3f temp = from;
                from = to;
                to = temp;
            }
        } else {
            float[] lineSegments = new float[2 * (vertices + 1)];
            for (int a = 0; a <= vertices; ++a) {
                float x2 = (float)Math.sin((double)a * Math.PI * 2.0 / (double)vertices) * (radiusX + 0.5f);
                float z2 = (float)Math.cos((double)a * Math.PI * 2.0 / (double)vertices) * (radiusZ + 0.5f);
                lineSegments[a * 2] = x2;
                lineSegments[a * 2 + 1] = z2;
            }
            RasterizationHelper.planeCondition(center, diameterX, diameterZ, quaternionf, (x, y) -> {
                for (int i = 0; i < lineSegments.length - 2; i += 2) {
                    float x2 = lineSegments[i + 2];
                    float x1 = lineSegments[i];
                    float y1 = lineSegments[i + 1];
                    float y2 = lineSegments[i + 3];
                    if (!((x2 - x1) * (y - y1) - (y2 - y1) * (x - x1) > 0.0f)) continue;
                    return false;
                }
                return true;
            }, consumer);
        }
    }
}

