/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class PlaneRasterization {
    public static void plane(Vector3i center, int diameterX, int diameterZ, boolean hollow, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        if (hollow) {
            float offsetX = radiusX % 1.0f + 0.5f;
            float offsetZ = radiusZ % 1.0f + 0.5f;
            Vector3f one = new Vector3f(-(radiusX - 0.15f) + offsetX, 0.5f, -(radiusZ - 0.15f) + offsetZ);
            quaternionf.transformInverse(one);
            Vector3f two = new Vector3f(-(radiusX - 0.15f) + offsetX, 0.5f, radiusZ - 0.15f + offsetZ);
            quaternionf.transformInverse(two);
            Vector3f three = new Vector3f(radiusX - 0.15f + offsetX, 0.5f, radiusZ - 0.15f + offsetZ);
            quaternionf.transformInverse(three);
            Vector3f four = new Vector3f(radiusX - 0.15f + offsetX, 0.5f, -(radiusZ - 0.15f) + offsetZ);
            quaternionf.transformInverse(four);
            TriIntConsumer offsetConsumer = (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ);
            Rasterization3D.dda(one, two, offsetConsumer);
            Rasterization3D.dda(two, three, offsetConsumer);
            Rasterization3D.dda(three, four, offsetConsumer);
            Rasterization3D.dda(four, one, offsetConsumer);
        } else {
            RasterizationHelper.planeCondition(center, diameterX, diameterZ, quaternionf, (x, y) -> Math.abs(x) <= radiusX && Math.abs(y) <= radiusZ, consumer);
        }
    }
}

