/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather.async;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.funcinterfaces.IntIntIntFloatConsumer;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.utils.Box;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class AsyncToolPatherMinSDF
implements AsyncToolPather {
    private final int[] sphere;
    private final int[][] cardinalHalfBalls;
    private final int[][][] bicardinalBallSlices;
    private final Position2FloatMap minDistances = new Position2FloatMap(Float.MAX_VALUE);
    private final IntIntIntFloatConsumer consumer;
    private final class_2338.class_2339 lastPosition = new class_2338.class_2339();
    protected final ArrayBlockingQueue<int[]> outputData = new ArrayBlockingQueue(128);

    public AsyncToolPatherMinSDF(BrushShape brushShape, IntIntIntFloatConsumer consumer) {
        int i;
        this.consumer = consumer;
        IntArrayList sphere = new IntArrayList();
        List<IntArrayList> cardinalHalfSpheres = List.of(new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList());
        ArrayList bicardinalSphereSlices = new ArrayList();
        for (int i2 = 0; i2 < class_2350.values().length; ++i2) {
            ArrayList<IntArrayList> list = new ArrayList<IntArrayList>();
            for (int j = 0; j < class_2350.values().length; ++j) {
                list.add(new IntArrayList());
            }
            bicardinalSphereSlices.add(list);
        }
        Box bounding = brushShape.boundingBox();
        int minX = bounding.pos1().method_10263();
        int minY = bounding.pos1().method_10264();
        int minZ = bounding.pos1().method_10260();
        int maxX = bounding.pos2().method_10263();
        int maxY = bounding.pos2().method_10264();
        int maxZ = bounding.pos2().method_10260();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!brushShape.isInsideShape(x, y, z)) continue;
                    float sdf = brushShape.sdf(x, y, z);
                    int encodedDistance = Float.floatToIntBits(sdf);
                    sphere.add(x);
                    sphere.add(y);
                    sphere.add(z);
                    sphere.add(encodedDistance);
                    for (class_2350 direction : class_2350.values()) {
                        int x2 = x + direction.method_10148();
                        int y2 = y + direction.method_10164();
                        int z2 = z + direction.method_10165();
                        float sdf2 = brushShape.sdf(x2, y2, z2);
                        if (brushShape.isInsideShape(x2, y2, z2) && !(sdf2 >= sdf)) continue;
                        IntList cardinalHalfSphere = (IntList)cardinalHalfSpheres.get(direction.method_10146());
                        cardinalHalfSphere.add(x);
                        cardinalHalfSphere.add(y);
                        cardinalHalfSphere.add(z);
                        cardinalHalfSphere.add(encodedDistance);
                        List cardinalSphereSlices = (List)bicardinalSphereSlices.get(direction.method_10146());
                        for (class_2350 direction2 : class_2350.values()) {
                            int x3 = x - direction2.method_10148();
                            int y3 = y - direction2.method_10164();
                            int z3 = z - direction2.method_10165();
                            float sdf3 = brushShape.sdf(x3, y3, z3);
                            if (brushShape.isInsideShape(x3, y3, z3) && !(sdf3 >= sdf)) continue;
                            IntList cardinalSphereSlice = (IntList)cardinalSphereSlices.get(direction2.method_10146());
                            cardinalSphereSlice.add(x);
                            cardinalSphereSlice.add(y);
                            cardinalSphereSlice.add(z);
                            cardinalSphereSlice.add(encodedDistance);
                        }
                    }
                }
            }
        }
        this.sphere = sphere.toIntArray();
        this.cardinalHalfBalls = new int[6][];
        for (i = 0; i < 6; ++i) {
            this.cardinalHalfBalls[i] = ((IntList)cardinalHalfSpheres.get(i)).toIntArray();
        }
        this.bicardinalBallSlices = new int[6][6][];
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.bicardinalBallSlices[i][j] = ((IntArrayList)((List)bicardinalSphereSlices.get(i)).get(j)).toIntArray();
            }
        }
    }

    @Override
    public void update() {
        int[] positions;
        while ((positions = this.outputData.poll()) != null) {
            for (int i = 0; i < positions.length; i += 4) {
                this.consumer.accept(positions[i], positions[i + 1], positions[i + 2], Float.intBitsToFloat(positions[i + 3]));
            }
        }
    }

    @Override
    public void acceptInitial(long position) {
        int x = class_2338.method_10061((long)position);
        int y = class_2338.method_10071((long)position);
        int z = class_2338.method_10083((long)position);
        this.lastPosition.method_10103(x, y, z);
        IntArrayList outputs = new IntArrayList();
        for (int i = 0; i < this.sphere.length; i += 4) {
            int xo = this.sphere[i] + x;
            int yo = this.sphere[i + 1] + y;
            int zo = this.sphere[i + 2] + z;
            float distance = Float.intBitsToFloat(this.sphere[i + 3]);
            if (!this.minDistances.min(xo, yo, zo, distance)) continue;
            outputs.add(xo);
            outputs.add(yo);
            outputs.add(zo);
            outputs.add(this.sphere[i + 3]);
        }
        if (!outputs.isEmpty()) {
            try {
                this.outputData.put(outputs.toIntArray());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void accept(long[] positions) {
        if (positions.length == 0) {
            return;
        }
        int lastX = this.lastPosition.method_10263();
        int lastY = this.lastPosition.method_10264();
        int lastZ = this.lastPosition.method_10260();
        int currX = class_2338.method_10061((long)positions[0]);
        int currY = class_2338.method_10071((long)positions[0]);
        int currZ = class_2338.method_10083((long)positions[0]);
        Position2FloatMap newMinimums = new Position2FloatMap(Float.MAX_VALUE);
        for (int posIndex = 1; posIndex < positions.length; ++posIndex) {
            long position = positions[posIndex];
            int nextX = class_2338.method_10061((long)position);
            int nextY = class_2338.method_10071((long)position);
            int nextZ = class_2338.method_10083((long)position);
            int dx = currX - lastX;
            int dy = currY - lastY;
            int dz = currZ - lastZ;
            int firstIndex = this.getDirectionFromDelta(dx, dy, dz);
            dx = nextX - currX;
            dy = nextY - currY;
            dz = nextZ - currZ;
            int secondIndex = this.getDirectionFromDelta(dx, dy, dz);
            int[] offsets = this.bicardinalBallSlices[firstIndex][secondIndex];
            for (int i = 0; i < offsets.length; i += 4) {
                int xo = offsets[i] + currX;
                int yo = offsets[i + 1] + currY;
                int zo = offsets[i + 2] + currZ;
                float distance2 = Float.intBitsToFloat(offsets[i + 3]);
                if (!this.minDistances.min(xo, yo, zo, distance2)) continue;
                newMinimums.put(xo, yo, zo, distance2);
            }
            lastX = currX;
            lastY = currY;
            lastZ = currZ;
            currX = nextX;
            currY = nextY;
            currZ = nextZ;
        }
        int dx = currX - lastX;
        int dy = currY - lastY;
        int dz = currZ - lastZ;
        int directionIndex = this.getDirectionFromDelta(dx, dy, dz);
        int[] offsets = this.cardinalHalfBalls[directionIndex];
        for (int i = 0; i < offsets.length; i += 4) {
            int xo = offsets[i] + currX;
            int yo = offsets[i + 1] + currY;
            int zo = offsets[i + 2] + currZ;
            float distance3 = Float.intBitsToFloat(offsets[i + 3]);
            if (!this.minDistances.min(xo, yo, zo, distance3)) continue;
            newMinimums.put(xo, yo, zo, distance3);
        }
        IntArrayList outputs = new IntArrayList();
        newMinimums.forEachEntry((x, y, z, distance) -> {
            outputs.add(x);
            outputs.add(y);
            outputs.add(z);
            outputs.add(Float.floatToIntBits(distance));
        });
        if (!outputs.isEmpty()) {
            try {
                this.outputData.put(outputs.toIntArray());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.lastPosition.method_10103(currX, currY, currZ);
    }

    private int getDirectionFromDelta(int dx, int dy, int dz) {
        if (dx == 0) {
            if (dy == 0) {
                if (dz == 1) {
                    return 3;
                }
                if (dz == -1) {
                    return 2;
                }
                throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
            }
            if (dz == 0) {
                if (dy == 1) {
                    return 1;
                }
                if (dy == -1) {
                    return 0;
                }
                throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
            }
            throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
        }
        if (dy == 0 && dz == 0) {
            if (dx == 1) {
                return 5;
            }
            if (dx == -1) {
                return 4;
            }
            throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
        }
        throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
    }
}

