/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.pather.ToolPatherPoint;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.pathers.ToolPatherUnique;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2335;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ToolPatherSurface
implements ToolPatherUnique {
    private final int[] sphere;
    private final int[][] cardinal;
    private final Position2dToIntMap heightMap = new Position2dToIntMap(Integer.MIN_VALUE);
    private final PositionSet checked = new PositionSet();
    private MaskContext maskContext = null;
    private class_2338.class_2339 lastBlockPosition = null;
    private class_243 lastPosition = null;
    private class_243 lastLookDirection = null;
    private final MaskElement maskElement;
    private final int surfaceDirection;
    private final class_2335 axisCycle;
    private final class_2335 axisCycleInverse;

    public ToolPatherSurface(int radius, BallShape ballShape, MaskElement mask, class_2350 direction) {
        radius = Math.max(0, radius);
        this.maskElement = mask;
        this.surfaceDirection = direction.method_10171() == class_2350.class_2352.field_11060 ? -1 : 1;
        this.axisCycle = class_2335.method_10057((class_2350.class_2351)direction.method_10166(), (class_2350.class_2351)class_2350.class_2351.field_11052);
        this.axisCycleInverse = this.axisCycle.method_10055();
        IntArrayList sphere = new IntArrayList();
        List<IntArrayList> cardinal = List.of(new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList());
        float radiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int z = -radius; z <= radius; ++z) {
                for (int y = radius; y >= 0; --y) {
                    IntList list;
                    float distanceSq = ballShape.distanceSq(x, y, z);
                    if (!(distanceSq <= radiusSq)) continue;
                    sphere.add(x);
                    sphere.add(y);
                    sphere.add(z);
                    if (x <= 0) {
                        list = (IntList)cardinal.get(0);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (z <= 0) {
                        list = (IntList)cardinal.get(1);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (x >= 0) {
                        list = (IntList)cardinal.get(2);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (z < 0) continue block1;
                    list = (IntList)cardinal.get(3);
                    list.add(x);
                    list.add(y);
                    list.add(z);
                    continue block1;
                }
            }
        }
        this.sphere = sphere.toIntArray();
        this.cardinal = new int[4][];
        for (int i = 0; i < 4; ++i) {
            this.cardinal[i] = ((IntList)cardinal.get(i)).toIntArray();
        }
    }

    public boolean update(TriIntConsumer consumer) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return false;
        }
        class_243 lookDirection = null;
        if (EditorUI.isActive()) {
            if (EditorUI.isMovingCamera()) {
                return false;
            }
            lookDirection = EditorUI.getMouseLookVector();
        } else if (class_310.method_1551().method_1560() != null) {
            lookDirection = class_310.method_1551().method_1560().method_5720();
        }
        if (lookDirection == null) {
            return false;
        }
        class_243 start = entity.method_33571();
        boolean includeFluids = Tool.defaultIncludeFluids();
        class_1937 level = entity.method_37908();
        if (this.maskContext == null) {
            this.maskContext = new MaskContext(level);
        }
        int xo = this.axisCycleInverse.method_10056(0, this.surfaceDirection, 0, class_2350.class_2351.field_11048);
        int yo = this.axisCycleInverse.method_10056(0, this.surfaceDirection, 0, class_2350.class_2351.field_11052);
        int zo = this.axisCycleInverse.method_10056(0, this.surfaceDirection, 0, class_2350.class_2351.field_11051);
        if (this.lastLookDirection == null || this.lastBlockPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(level, start.method_46409(), lookDirection.method_46409(), false, includeFluids, false);
            if (raycastResult != null) {
                this.lastLookDirection = lookDirection;
                this.lastBlockPosition = raycastResult.getBlockPos().method_25503();
                this.lastPosition = raycastResult.getPositionWithinBlock();
                int x2 = this.lastBlockPosition.method_10263();
                int y2 = this.lastBlockPosition.method_10264();
                int z2 = this.lastBlockPosition.method_10260();
                block0: for (int i = 0; i < this.sphere.length; i += 3) {
                    int a = this.sphere[i] + this.axisCycle.method_10056(x2, y2, z2, class_2350.class_2351.field_11048);
                    int height = this.sphere[i + 1];
                    int c = this.sphere[i + 2] + this.axisCycle.method_10056(x2, y2, z2, class_2350.class_2351.field_11051);
                    int lastB = this.axisCycle.method_10056(x2, y2, z2, class_2350.class_2351.field_11052) * this.surfaceDirection;
                    int fromB = lastB - height;
                    int toB = lastB + height;
                    int oldB = this.heightMap.get(a, c);
                    if (fromB < oldB) {
                        fromB = oldB;
                    }
                    if (oldB > toB) continue;
                    for (int b = toB; b >= fromB; --b) {
                        int z1;
                        int y1;
                        int x1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11048);
                        if (!this.checked.add(x1, y1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11052), z1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11051))) continue;
                        this.maskContext.reset();
                        if (!this.maskContext.getBlockState(x1, y1, z1).method_51366() || this.maskContext.getBlockState(x1, y1, z1, xo, yo, zo).method_51366() || this.maskElement != null && !this.maskElement.test(this.maskContext, x1, y1, z1)) continue;
                        this.heightMap.put(a, c, b);
                        consumer.accept(x1, y1, z1);
                        continue block0;
                    }
                }
            }
            return true;
        }
        BooleanWrapper changed = new BooleanWrapper(false);
        double dot = this.lastLookDirection.method_1026(lookDirection);
        double angleChange = Math.toDegrees(Math.acos(dot));
        int steps = 1;
        if (angleChange > 1.0) {
            steps = (int)Math.ceil(angleChange);
        }
        for (int i = 1; i <= steps; ++i) {
            float f = (float)i / (float)steps;
            class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(level, start.method_46409(), look.method_46409(), false, includeFluids, false);
            if (raycastResult == null) continue;
            class_243 withinBlock = raycastResult.getPositionWithinBlock();
            if (raycastResult.getBlockPos().equals((Object)this.lastBlockPosition)) {
                this.lastPosition = withinBlock;
                continue;
            }
            ToolPatherPoint.smartDDASkipFrom(level, this.lastPosition, withinBlock, false, (x, y, z) -> {
                int[] offsets;
                int rawDx = x - this.lastBlockPosition.method_10263();
                int rawDy = y - this.lastBlockPosition.method_10264();
                int rawDz = z - this.lastBlockPosition.method_10260();
                int dx = this.axisCycleInverse.method_10056(rawDx, rawDy, rawDz, class_2350.class_2351.field_11048);
                int dy = this.axisCycleInverse.method_10056(rawDx, rawDy, rawDz, class_2350.class_2351.field_11052);
                int dz = this.axisCycleInverse.method_10056(rawDx, rawDy, rawDz, class_2350.class_2351.field_11051);
                if (dy != 0) {
                    offsets = this.sphere;
                } else if (dx == 0) {
                    if (dz == 0) {
                        return;
                    }
                    if (dz == 1) {
                        offsets = this.cardinal[3];
                    } else {
                        if (dz != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[1];
                    }
                } else {
                    if (dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                    if (dx == 1) {
                        offsets = this.cardinal[2];
                    } else {
                        if (dx != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[0];
                    }
                }
                block0: for (int j = 0; j < offsets.length; j += 3) {
                    int a = offsets[j] + this.axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11048);
                    int height = offsets[j + 1];
                    int c = offsets[j + 2] + this.axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11051);
                    int lastB = this.axisCycle.method_10056(x, y, z, class_2350.class_2351.field_11052) * this.surfaceDirection;
                    int fromB = lastB - height;
                    int toB = lastB + height;
                    int oldB = this.heightMap.get(a, c);
                    if (fromB < oldB) {
                        fromB = oldB;
                    }
                    if (oldB > toB) continue;
                    for (int b = toB; b >= fromB; --b) {
                        int z1;
                        int y1;
                        int x1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11048);
                        if (!this.checked.add(x1, y1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11052), z1 = this.axisCycleInverse.method_10056(a, b * this.surfaceDirection, c, class_2350.class_2351.field_11051))) continue;
                        this.maskContext.reset();
                        if (!this.maskContext.getBlockState(x1, y1, z1).method_51366() || this.maskContext.getBlockState(x1, y1, z1, xo, yo, zo).method_51366() || this.maskElement != null && !this.maskElement.test(this.maskContext, x1, y1, z1)) continue;
                        this.heightMap.put(a, c, b);
                        changed.value = true;
                        consumer.accept(x1, y1, z1);
                        continue block0;
                    }
                }
                this.lastBlockPosition.method_10103(x, y, z);
            });
            this.lastPosition = withinBlock;
        }
        this.lastLookDirection = lookDirection;
        return changed.value;
    }
}

