/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets.blueprint;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomClientboundPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5455;

public class AxiomClientboundBlueprintManifest
implements AxiomClientboundPacket {
    private static final class_2960 IDENTIFIER = class_2960.method_60654((String)"axiom:blueprint_manifest");
    private final boolean replace;
    private final ServerBlueprintRegistry registry;
    private final class_2540 rawByteBuf;
    private static final int MAX_SIZE = 1000000;

    public AxiomClientboundBlueprintManifest(boolean replace, ServerBlueprintRegistry registry) {
        this.replace = replace;
        this.registry = registry;
        this.rawByteBuf = null;
    }

    public AxiomClientboundBlueprintManifest(class_2540 rawByteBuf) {
        this.replace = false;
        this.registry = null;
        this.rawByteBuf = rawByteBuf;
    }

    public static AxiomClientboundBlueprintManifest read(class_2540 friendlyByteBuf) {
        ServerConfig serverConfig = Axiom.getInstance().serverConfig;
        if (serverConfig == null) {
            serverConfig = AxiomClientboundEnable.lastReadServerConfig;
        }
        if (serverConfig == null || serverConfig.blueprintVersion() != ServerConfig.BLUEPRINT_VERSION) {
            friendlyByteBuf.method_52988(friendlyByteBuf.writerIndex());
            return new AxiomClientboundBlueprintManifest(true, new ServerBlueprintRegistry(new HashMap<String, RawBlueprint>()));
        }
        boolean replace = friendlyByteBuf.readBoolean();
        ServerBlueprintRegistry registry = ServerBlueprintRegistry.readManifest(friendlyByteBuf);
        return new AxiomClientboundBlueprintManifest(replace, registry);
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        if (this.rawByteBuf != null) {
            friendlyByteBuf.method_52975((ByteBuf)this.rawByteBuf);
            return;
        }
        friendlyByteBuf.method_52964(this.replace);
        this.registry.writeManifest(friendlyByteBuf);
    }

    public static void sendMulti(class_3222 serverPlayer, ServerBlueprintRegistry registry) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52964(true);
        for (Map.Entry<String, RawBlueprint> entry : registry.blueprints().entrySet()) {
            buf.method_10814(entry.getKey());
            RawBlueprint.writeHeader(buf, entry.getValue());
            if (buf.writerIndex() <= 1000000) continue;
            buf.method_10814("");
            new AxiomClientboundBlueprintManifest(buf).send(serverPlayer);
            buf = new class_2540(Unpooled.buffer());
            buf.method_52964(false);
        }
        buf.method_10814("");
        new AxiomClientboundBlueprintManifest(buf).send(serverPlayer);
    }

    @Override
    public void handle(class_310 client, class_5455 registryAccess) {
        BlueprintBrowserWindow.setServerBlueprintRegistry(this.replace, this.registry);
    }

    public static void register() {
        AxiomClientboundPacket.register(IDENTIFIER, AxiomClientboundBlueprintManifest::read);
    }
}

