/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.annotations.AnnotationHistoryElement;
import com.moulberry.axiom.annotations.data.TextAnnotationData;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.packets.AxiomServerboundTeleport;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.render.annotations.Annotations;
import com.moulberry.axiom.render.annotations.TextAnnotation;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3f;

public class TextAnnotationListWindow {
    private static List<TextAnnotationEntry> textAnnotations = null;
    private static final ImString searchString = ImGuiHelper.createResizableString(32);
    private static String lastSearch = null;

    public static void invalidateTextAnnotations() {
        textAnnotations = null;
    }

    private static List<TextAnnotationEntry> getTextAnnotations() {
        String search = ImGuiHelper.getString(searchString).toLowerCase(Locale.ROOT);
        if (textAnnotations == null || lastSearch == null || !Objects.equals(lastSearch, search)) {
            if (textAnnotations == null) {
                textAnnotations = new ArrayList<TextAnnotationEntry>();
            } else {
                textAnnotations.clear();
            }
            lastSearch = search;
            if (!search.isEmpty()) {
                ArrayList<TextAnnotationEntry> textAnnotationContains = new ArrayList<TextAnnotationEntry>();
                int index = 0;
                for (Map.Entry<UUID, Annotation> entry : Annotations.allAnnotations()) {
                    Annotation annotation = entry.getValue();
                    if (!(annotation instanceof TextAnnotation)) continue;
                    TextAnnotation textAnnotation = (TextAnnotation)annotation;
                    String text = ((TextAnnotationData)textAnnotation.getData()).text();
                    String textLower = text.toLowerCase(Locale.ROOT);
                    if (textLower.startsWith(search)) {
                        textAnnotations.add(new TextAnnotationEntry(entry.getKey(), textAnnotation, index));
                    } else if (textLower.contains(search)) {
                        textAnnotationContains.add(new TextAnnotationEntry(entry.getKey(), textAnnotation, index));
                    }
                    ++index;
                }
                textAnnotations.addAll(textAnnotationContains);
            } else {
                int index = 0;
                for (Map.Entry<UUID, Annotation> entry : Annotations.allAnnotations()) {
                    Annotation annotation = entry.getValue();
                    if (!(annotation instanceof TextAnnotation)) continue;
                    TextAnnotation textAnnotation = (TextAnnotation)annotation;
                    textAnnotations.add(new TextAnnotationEntry(entry.getKey(), textAnnotation, index));
                    ++index;
                }
            }
        }
        return textAnnotations;
    }

    public static void render() {
        if (!EditorWindowType.TEXT_ANNOTATIONS.isOpen()) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity == null) {
            return;
        }
        if (EditorWindowType.TEXT_ANNOTATIONS.begin("###TextAnnotationList", true)) {
            ImGui.inputText("Search", searchString);
            if (ImGui.beginChild("##TextAnnotations", 0.0f, 0.0f, true)) {
                final List<TextAnnotationEntry> textAnnotations = TextAnnotationListWindow.getTextAnnotations();
                if (textAnnotations.isEmpty()) {
                    ImGui.text("No text annotations found :(");
                } else {
                    ImGuiListClipper.forEach(textAnnotations.size(), new ImListClipperCallback(){

                        @Override
                        public void accept(int index) {
                            String newText;
                            TextAnnotationEntry entry = (TextAnnotationEntry)textAnnotations.get(index);
                            TextAnnotation annotation = entry.textAnnotation();
                            ImGui.pushID(entry.index);
                            ImGuiHelper.separatorWithText("#" + (entry.index + 1));
                            TextAnnotationData textAnnotationData = (TextAnnotationData)annotation.getData();
                            Vector3f position = textAnnotationData.position();
                            ImString textInput = new ImString(textAnnotationData.text());
                            textInput.inputData.isResizable = true;
                            ImGui.inputTextMultiline("##Text", textInput, -1.0f, 100.0f, 0);
                            if (ImGui.isItemDeactivatedAfterEdit() && !(newText = ImGuiHelper.getString(textInput)).isBlank() && !newText.equals(textAnnotationData.text())) {
                                TextAnnotationData newData = textAnnotationData.withText(newText);
                                Annotations.pushUpdateAnnotation(entry.uuid(), textAnnotationData, newData);
                            }
                            StringBuilder teleport = new StringBuilder();
                            teleport.append("Teleport (");
                            teleport.append((int)Math.floor(position.x()));
                            teleport.append(", ");
                            teleport.append((int)Math.floor(position.y()));
                            teleport.append(", ");
                            teleport.append((int)Math.floor(position.z()));
                            teleport.append(")");
                            if (ImGui.smallButton(teleport.toString())) {
                                class_746 player = class_310.method_1551().field_1724;
                                new AxiomServerboundTeleport((class_5321<class_1937>)player.method_37908().method_27983(), position.x, position.y, position.z, player.method_36454(), player.method_36455()).send();
                            }
                            ImGui.sameLine();
                            if (ImGui.smallButton("Remove")) {
                                Annotations.push(AnnotationHistoryElement.makeDeleteAnnotation(entry.uuid(), textAnnotationData));
                            }
                            ImGui.popID();
                        }
                    });
                }
            }
            ImGui.endChild();
        }
        EditorWindowType.TEXT_ANNOTATIONS.end();
    }

    private record TextAnnotationEntry(UUID uuid, TextAnnotation textAnnotation, int index) {
    }
}

