/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.ButtonSpacingSpec;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.palette.ActiveBlockHistory;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.editor.windows.PaletteWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import imgui.ImGui;
import java.time.Duration;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class InventoryWindow {
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private static final Cache<class_1799, CustomBlockState> itemStackCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build();

    public static void render(ActiveBlockHistory activeBlockHistory, BlockList blockList) {
        if (!EditorWindowType.INVENTORY.isOpen()) {
            return;
        }
        int buttonSize = (int)(28.0f * EditorUI.getUiScale());
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!Configuration.internal.dockedInventoryWithPalette && EditorWindowType.PALETTE.isOpen()) {
            Configuration.internal.dockedInventoryWithPalette = true;
            if (PaletteWindow.lastDockId != Integer.MIN_VALUE) {
                ImGui.setNextWindowDockID(PaletteWindow.lastDockId);
            }
        }
        if (EditorWindowType.INVENTORY.begin("###Inventory", true)) {
            float currentX;
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.inventory.hotbar"));
            float availX = (float)Math.floor(ImGui.getContentRegionAvailX());
            availX = Math.max(availX, (float)(buttonSize * 4));
            ButtonSpacingSpec spec = ButtonSpacingSpec.calculate(availX, buttonSize, 9, 6.0f, false);
            CustomBlockState toSetActive = null;
            float originalPositionX = currentX = ImGui.getCursorPosX();
            float currentY = ImGui.getCursorPosY();
            int rowCount = 0;
            for (int id = 0; id < 36; ++id) {
                if (id == 9) {
                    ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.inventory.inventory"));
                    originalPositionX = currentX = ImGui.getCursorPosX();
                    currentY = ImGui.getCursorPosY();
                    rowCount = 0;
                }
                class_1799 inventoryItem = EditorUI.inventoryOverrides.containsKey(id) ? (class_1799)EditorUI.inventoryOverrides.get(id) : player.method_31548().method_5438(id);
                CustomBlockState customBlockState = itemStackCache.get(inventoryItem, InventoryWindow::getCustomBlockStateForItemStack);
                ImGui.setCursorPos(currentX, currentY);
                if (ImGuiHelper.blockStateButton(customBlockState, id, buttonSize)) {
                    toSetActive = customBlockState;
                }
                if (ImGui.isItemClicked(1)) {
                    selectBlockWidget.open(id);
                }
                selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), blockList, id);
                CustomBlockState result = selectBlockWidget.getResultState();
                if (result != null) {
                    EditorUI.inventoryOverrides.put(id, (Object)result.getCustomBlock().axiom$asItemStack());
                }
                if (ImGui.isItemHovered()) {
                    ImGui.setMouseCursor(7);
                }
                ImGuiHelper.blockStateDragDropSource(customBlockState);
                if (++rowCount == spec.buttonsPerRow()) {
                    currentX = originalPositionX;
                    currentY += (float)buttonSize + spec.spacingY();
                    rowCount = 0;
                    continue;
                }
                currentX += (float)buttonSize + spec.spacingX();
            }
            if (toSetActive != null) {
                activeBlockHistory.setActive(toSetActive);
            }
        }
        EditorWindowType.INVENTORY.end();
    }

    private static CustomBlockState getCustomBlockStateForItemStack(class_1799 inventoryItem) {
        class_2680 updatedVanillaState;
        CustomBlock customBlock = ServerCustomBlocks.getFromItemStack(inventoryItem);
        CustomBlockState customBlockState = customBlock.axiom$defaultCustomState();
        class_2680 vanillaState = customBlockState.getVanillaState();
        if (vanillaState != (updatedVanillaState = ItemStackDataHelper.updateBlockStateFromTag(vanillaState, inventoryItem))) {
            return (CustomBlockState)updatedVanillaState;
        }
        return customBlockState;
    }
}

