/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.StaticValues;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.CustomImGuiImplGl3;
import com.moulberry.axiom.editor.CustomImGuiImplGlfw;
import com.moulberry.axiom.editor.DragDropPayloads;
import com.moulberry.axiom.editor.EditorMovementControls;
import com.moulberry.axiom.editor.EditorWarningType;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.ImageReferenceWindows;
import com.moulberry.axiom.editor.PendingDepthAction;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.palette.ActiveBlockHistory;
import com.moulberry.axiom.editor.palette.CustomBlockStateOrTombstone;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.editor.styles.StyleManager;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.editor.views.View;
import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.editor.windows.BlueprintCreateWindow;
import com.moulberry.axiom.editor.windows.ClipboardInstallationWindow;
import com.moulberry.axiom.editor.windows.CurrentBlockWindow;
import com.moulberry.axiom.editor.windows.DebugInfoWindow;
import com.moulberry.axiom.editor.windows.HistoryWindow;
import com.moulberry.axiom.editor.windows.InventoryWindow;
import com.moulberry.axiom.editor.windows.KeybindsWindow;
import com.moulberry.axiom.editor.windows.MainMenuBar;
import com.moulberry.axiom.editor.windows.PaletteWindow;
import com.moulberry.axiom.editor.windows.PlacementOptionsOverlay;
import com.moulberry.axiom.editor.windows.RotatePlacementWindow;
import com.moulberry.axiom.editor.windows.StyleEditorWindow;
import com.moulberry.axiom.editor.windows.TargetInfoWindow;
import com.moulberry.axiom.editor.windows.TextAnnotationListWindow;
import com.moulberry.axiom.editor.windows.ToolOptionsWindow;
import com.moulberry.axiom.editor.windows.ToolsWindow;
import com.moulberry.axiom.editor.windows.WorldPropertiesWindow;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.editor.windows.clipboard.ClipboardWindow;
import com.moulberry.axiom.editor.windows.global_mask.ToolMaskWindow;
import com.moulberry.axiom.editor.windows.operations.AnalyzeBlocksWindow;
import com.moulberry.axiom.editor.windows.operations.AnimatedRebuildWindow;
import com.moulberry.axiom.editor.windows.operations.AutoshadeWindow;
import com.moulberry.axiom.editor.windows.operations.FillBlocksWindow;
import com.moulberry.axiom.editor.windows.operations.QuickFillWindow;
import com.moulberry.axiom.editor.windows.operations.QuickReplaceWindow;
import com.moulberry.axiom.editor.windows.operations.ReplaceBlocksWindow;
import com.moulberry.axiom.editor.windows.operations.SetBiomeWindow;
import com.moulberry.axiom.editor.windows.operations.TypeReplaceBlocksWindow;
import com.moulberry.axiom.editor.windows.save_world.ExportSchematicWindow;
import com.moulberry.axiom.editor.windows.selection.DistortSelectionWindow;
import com.moulberry.axiom.editor.windows.selection.ExpandSelectionWindow;
import com.moulberry.axiom.editor.windows.selection.MaskSelectionWindow;
import com.moulberry.axiom.editor.windows.selection.ShrinkSelectionWindow;
import com.moulberry.axiom.editor.windows.selection.SmoothSelectionWindow;
import com.moulberry.axiom.hooks.WindowExt;
import com.moulberry.axiom.hooks.WorldRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.integration.ServerIntegration;
import com.moulberry.axiom.operations.FillOperation;
import com.moulberry.axiom.render.BiomeOverlayRenderer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.magic_select.MagicSelectionFast;
import com.moulberry.axiom.tools.modify.ModifyTool;
import com.moulberry.axiom.tools.ruler.RulerTool;
import com.moulberry.axiom.tools.shape.ShapeTool;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import imgui.ImDrawData;
import imgui.ImDrawList;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImFontGlyphRangesBuilder;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import imgui.internal.ImGuiContext;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1078;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.glfw.GLFW;

public class EditorUI {
    public static final CustomImGuiImplGlfw imguiGlfw = new CustomImGuiImplGlfw();
    private static final CustomImGuiImplGl3 imguiGl3 = new CustomImGuiImplGl3();
    private static boolean initialized = false;
    private static boolean enabled = false;
    private static boolean isFrameHovered = false;
    public static int frameX = 0;
    public static int frameY = 0;
    public static int frameWidth = 1;
    public static int frameHeight = 1;
    public static int viewportSizeX = 1;
    public static int viewportSizeY = 1;
    private static boolean activeLastFrame = false;
    public static boolean canProcessKeybinds = false;
    public static EditorMovementControls movementControls = EditorMovementControls.none();
    private static boolean adjustingTool = false;
    private static float adjustingToolOffsetX = 0.0f;
    private static float adjustingToolOffsetY = 0.0f;
    private static float savedEditorFlightSpeed = -1.0f;
    private static float savedGameFlightSpeed = -1.0f;
    public static Matrix4f lastProjectionMatrix = null;
    public static Quaternionf lastViewQuaternion = null;
    private static ImFont font = null;
    public static ImFont icons = null;
    private static String languageCode = null;
    private static boolean wasNavClose = false;
    private static boolean navClose = false;
    private static final Lock deferredCloseLock = new ReentrantLock();
    private static final IntList deferredCloseTextureIds = new IntArrayList();
    private static final List<AutoCloseable> deferredClose = new ArrayList<AutoCloseable>();
    private static final ActiveBlockHistory activeBlockHistory = new ActiveBlockHistory();
    private static final BlockList blockList = new BlockList();
    public static final EnumSet<EditorWarningType> warnings = EnumSet.noneOf(EditorWarningType.class);
    public static final List<PendingDepthAction> pendingDepthActions = new ArrayList<PendingDepthAction>();
    public static final Int2ObjectOpenHashMap<class_1799> inventoryOverrides = new Int2ObjectOpenHashMap();
    private static CustomBlockState draggingBlockFromWorld = null;
    private static float globalScale = 1.0f;
    public static float newGlobalScale = 1.0f;
    private static float contentScale = 1.0f;
    private static int focusViewNextFrame = -1;
    private static float viewportX = 0.0f;
    private static float viewportY = 0.0f;
    private static ImGuiContext imGuiContext = null;
    public static ImGuiIO imGuiIO = null;
    private static boolean isContextActive = false;

    public static void init() {
        if (initialized) {
            throw new IllegalStateException("EditorUI initialized twice");
        }
        initialized = true;
        newGlobalScale = globalScale = Configuration.internal.globalScale;
        Path path = Axiom.getInstance().getConfigDirectory().resolve("imgui.ini");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.write(path, "[Window][###Tools]\nPos=0,0\nSize=300,250\nCollapsed=0\nDockId=0x00000003,0\n\n[Window][###Tool Options]\nPos=0,250\nSize=300,750\nCollapsed=0\nDockId=0x00000004,0\n\n[Window][###Clipboard]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,0\n\n[Window][###TargetInfo]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,1\n\n[Window][###Palette]\nPos=1700,200\nSize=300,200\nCollapsed=0\nDockId=0x0000000E,0\n\n[Window][###ActiveBlock]\nPos=1700,400\nSize=300,100\nCollapsed=0\nDockId=0x0000000C,0\n\n[Window][###History]\nPos=1700,500\nSize=300,300\nCollapsed=0\nDockId=0x0000000A,0\n\n[Window][###WorldProperties]\nPos=1700,800\nSize=300,200\nCollapsed=0\nDockId=0x00000008,0\n\n[Docking][Data]\nDockSpace           ID=0x8B93E3BD Window=0xA787BDB4 Pos=0,0 Size=2000,1000 Split=X\nDockNode          ID=0x00000005 Parent=0x8B93E3BD SizeRef=1700,1000 Split=X\n DockNode        ID=0x00000001 Parent=0x00000005 SizeRef=300,1000 Split=Y\n   DockNode      ID=0x00000003 Parent=0x00000001 SizeRef=300,250 Selected=0x80AFE82B\n   DockNode      ID=0x00000004 Parent=0x00000001 SizeRef=300,750 Selected=0xECA27DCB\n DockNode        ID=0x00000002 Parent=0x00000005 SizeRef=1400,1000 CentralNode=1 Selected=0x1F1A625A\nDockNode          ID=0x00000006 Parent=0x8B93E3BD SizeRef=300,1000 Split=Y Selected=0x34064FA7\n DockNode        ID=0x00000007 Parent=0x00000006 SizeRef=300,800 Split=Y Selected=0x34064FA7\n   DockNode      ID=0x00000009 Parent=0x00000007 SizeRef=300,500 Split=Y Selected=0x34064FA7\n     DockNode    ID=0x0000000B Parent=0x00000009 SizeRef=300,400 Split=Y Selected=0x34064FA7\n       DockNode  ID=0x0000000D Parent=0x0000000B SizeRef=300,200 Selected=0x34064FA7\n       DockNode  ID=0x0000000E Parent=0x0000000B SizeRef=300,200 Selected=0x1E514AEA\n     DockNode    ID=0x0000000C Parent=0x00000009 SizeRef=300,100 Selected=0x1D216E21\n   DockNode      ID=0x0000000A Parent=0x00000007 SizeRef=300,300 Selected=0xFE0E9DDF\n DockNode        ID=0x00000008 Parent=0x00000006 SizeRef=300,200 Selected=0x602D8B84".getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long oldImGuiContext = ImGui.getCurrentContext().ptr;
        imGuiContext = new ImGuiContext(ImGui.createContext().ptr);
        ImGui.setCurrentContext(imGuiContext);
        imGuiIO = new ImGuiIO(ImGui.getIO().ptr);
        Path relativePath = FabricLoader.getInstance().getGameDir().relativize(path);
        Axiom.dbg("Using DearImGui config: " + String.valueOf(relativePath));
        EditorUI.getIO().setIniFilename(relativePath.toString());
        EditorUI.getIO().addConfigFlags(1);
        EditorUI.getIO().addConfigFlags(64);
        EditorUI.getIO().setConfigMacOSXBehaviors(class_310.field_1703);
        imguiGlfw.init(class_310.method_1551().method_22683().method_4490(), true);
        imguiGl3.init("#version 150");
        contentScale = EditorUI.imguiGlfw.contentScale;
        EditorUI.initFonts(languageCode);
        StyleManager.initialize();
        ImGuiContext currentContext = ImGui.getCurrentContext();
        currentContext.ptr = oldImGuiContext;
        ImGui.setCurrentContext(currentContext);
    }

    private static void addRanges(ImFontGlyphRangesBuilder builder, short[] ranges) {
        for (int i = 0; i < ranges.length && ranges[i] != 0; i += 2) {
            int from = ranges[i] & 0xFFFF;
            int to = ranges[i + 1] & 0xFFFF;
            for (int k = from; k <= to; ++k) {
                builder.addChar((char)k);
            }
        }
    }

    public static void initFonts(String languageCode) {
        if (languageCode != null) {
            EditorUI.languageCode = languageCode;
        } else {
            languageCode = "en_us";
        }
        if (!initialized) {
            return;
        }
        ImGuiIO io = EditorUI.getIO();
        ImFontAtlas fonts = io.getFonts();
        fonts.clear();
        int size = (int)(16.0f * EditorUI.getUiScale());
        ImFontGlyphRangesBuilder rangesBuilder = new ImFontGlyphRangesBuilder();
        rangesBuilder.addRanges(fonts.getGlyphRangesDefault());
        if (languageCode.startsWith("uk") || languageCode.startsWith("ru") || languageCode.startsWith("bg")) {
            EditorUI.addRanges(rangesBuilder, fonts.getGlyphRangesCyrillic());
        } else if (languageCode.startsWith("tr")) {
            rangesBuilder.addText("\u00c7\u00e7\u011e\u011f\u0130\u0131\u00d6\u00f6\u015e\u015f\u00dc\u00fc");
        } else if (languageCode.startsWith("pl")) {
            EditorUI.addRanges(rangesBuilder, new short[]{256, 383, 0});
        } else if (languageCode.startsWith("cs")) {
            rangesBuilder.addText("\u00c1\u00e1\u010c\u010d\u010e\u010f\u00c9\u00e9\u011a\u011b\u00cd\u00ed\u0147\u0148\u00d3\u00f3\u0158\u0159\u0160\u0161\u0164\u0165\u00da\u00fa\u016e\u016f\u00dd\u00fd\u017d\u017e");
        } else if (languageCode.startsWith("he")) {
            EditorUI.addRanges(rangesBuilder, new short[]{1424, 1535, -1251, -1201, 0});
        } else if (languageCode.startsWith("ja")) {
            EditorUI.addRanges(rangesBuilder, fonts.getGlyphRangesJapanese());
        } else if (languageCode.startsWith("zh")) {
            EditorUI.addRanges(rangesBuilder, fonts.getGlyphRangesChineseFull());
        } else if (languageCode.startsWith("ko")) {
            EditorUI.addRanges(rangesBuilder, fonts.getGlyphRangesKorean());
        }
        class_2477 class_24772 = class_2477.method_10517();
        if (class_24772 instanceof class_1078) {
            class_1078 clientLanguage = (class_1078)class_24772;
            for (String value : clientLanguage.field_5330.values()) {
                rangesBuilder.addText(value);
            }
        }
        rangesBuilder.addChar('\u2318');
        rangesBuilder.addChar('\u2303');
        rangesBuilder.addChar('\u2387');
        rangesBuilder.addChar('\u21e7');
        rangesBuilder.addChar('\u2756');
        rangesBuilder.addChar('\u26a0');
        rangesBuilder.addChar('\u2190');
        rangesBuilder.addChar('\u2191');
        rangesBuilder.addChar('\u2192');
        rangesBuilder.addChar('\u2193');
        for (int i = 32; i <= 348; ++i) {
            String key;
            int scancode = GLFW.glfwGetKeyScancode((int)i);
            if (scancode == -1 || (key = GLFW.glfwGetKeyName((int)i, (int)-1)) == null) continue;
            rangesBuilder.addText(key);
            rangesBuilder.addText(key.toLowerCase());
            rangesBuilder.addText(key.toUpperCase());
            rangesBuilder.addText(key.toLowerCase(Locale.ROOT));
            rangesBuilder.addText(key.toUpperCase(Locale.ROOT));
        }
        ImFontConfig fontConfig = new ImFontConfig();
        fontConfig.setOversampleH(2);
        fontConfig.setOversampleV(2);
        short[] glyphRanges = rangesBuilder.buildRanges();
        fontConfig.setName("Inter (Medium), 16px");
        font = fonts.addFontFromMemoryTTF(EditorUI.loadFont("inter-medium.ttf"), size, fontConfig, glyphRanges);
        fontConfig.setMergeMode(true);
        if (languageCode.startsWith("he")) {
            io.getFonts().addFontFromMemoryTTF(EditorUI.loadFont("heebo-medium.ttf"), size, fontConfig, glyphRanges);
        } else if (languageCode.startsWith("ja")) {
            io.getFonts().addFontFromMemoryTTF(EditorUI.loadFont("notosansjp-medium.ttf"), size * 5 / 4, fontConfig, glyphRanges);
        } else if (languageCode.startsWith("zh")) {
            io.getFonts().addFontFromMemoryTTF(EditorUI.loadFont("notosanstc-medium.ttf"), size * 5 / 4, fontConfig, glyphRanges);
            io.getFonts().addFontFromMemoryTTF(EditorUI.loadFont("notosanssc-medium.ttf"), size * 5 / 4, fontConfig, glyphRanges);
        }
        ImFontGlyphRangesBuilder emojiRangesBuilder = new ImFontGlyphRangesBuilder();
        emojiRangesBuilder.addChar('\u2714');
        emojiRangesBuilder.addChar('\u2716');
        emojiRangesBuilder.addChar('\u2b06');
        emojiRangesBuilder.addChar('\u2b07');
        emojiRangesBuilder.addChar('\u27a1');
        emojiRangesBuilder.addChar('\u2b05');
        emojiRangesBuilder.addChar('\u2620');
        emojiRangesBuilder.addChar('\u2622');
        emojiRangesBuilder.addChar('\u2764');
        emojiRangesBuilder.addChar('\u270f');
        io.getFonts().addFontFromMemoryTTF(EditorUI.loadFont("noto-emoji-stripped-bold.ttf"), size, fontConfig, emojiRangesBuilder.buildRanges());
        fontConfig.setMergeMode(false);
        glyphRanges = new short[]{-5888, -5848, 0};
        fontConfig.setName("Icons (don't select)");
        icons = fonts.addFontFromMemoryTTF(EditorUI.loadFont("axiomicons.ttf"), size * 2, fontConfig, glyphRanges);
        fonts.build();
        imguiGl3.updateFontsTexture();
        fontConfig.destroy();
        fonts.clearTexData();
    }

    private static byte[] loadFont(String name) {
        byte[] byArray;
        block9: {
            Optional resource = class_310.method_1551().method_1478().method_14486(class_2960.method_60655((String)"axiom", (String)name));
            if (resource.isEmpty()) {
                throw new MissingResourceException("Missing font: " + name, "Font", "");
            }
            InputStream is = ((class_3298)resource.get()).method_14482();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static ImGuiIO getIO() {
        return imGuiIO;
    }

    public static class_243 getMouseForwardsVector() {
        return EditorUI.getMouseForwardsVector(imGuiIO.getMousePosX(), imGuiIO.getMousePosY());
    }

    public static class_243 getMouseForwardsVector(float mouseX, float mouseY) {
        if (!EditorUI.isActive() || !isFrameHovered && !EditorUI.isMovingCamera() || lastProjectionMatrix == null || lastViewQuaternion == null) {
            return null;
        }
        return EditorUI.getForwardsVector(mouseX, mouseY);
    }

    public static class_241 getMouseViewportFraction() {
        float x = (imGuiIO.getMousePosX() - viewportX - (float)frameX) / (float)frameWidth;
        float y = (imGuiIO.getMousePosY() - viewportY - (float)frameY) / (float)frameHeight;
        return new class_241(x, y);
    }

    public static class_241 getMouseViewportFraction(float mouseX, float mouseY) {
        float x = (mouseX - viewportX - (float)frameX) / (float)frameWidth;
        float y = (mouseY - viewportY - (float)frameY) / (float)frameHeight;
        return new class_241(x, y);
    }

    public static class_243 getForwardsVector(float mouseX, float mouseY) {
        float x = (mouseX - viewportX - (float)frameX) / (float)frameWidth * 2.0f - 1.0f;
        float y = (mouseY - viewportY - (float)frameY) / (float)frameHeight * 2.0f - 1.0f;
        return EditorUI.getForwardsVectorRaw(x, y);
    }

    public static class_243 getForwardsVectorRaw(float x, float y) {
        if (!EditorUI.isMovingCamera() && (x < -1.0f || x > 1.0f || y < -1.0f || y > 1.0f)) {
            return null;
        }
        Matrix4f matrix = new Matrix4f((Matrix4fc)lastProjectionMatrix);
        matrix.invert();
        Vector4f forwards = new Vector4f(x, y, 0.0f, 1.0f);
        forwards.mul((Matrix4fc)matrix);
        return new class_243((double)forwards.x(), (double)(-forwards.y()), (double)forwards.z()).method_1029();
    }

    public static class_243 getMouseLookVectorFromForwards(class_243 forwards) {
        if (forwards == null) {
            return null;
        }
        Vector3f view = forwards.method_46409();
        view.rotate((Quaternionfc)lastViewQuaternion);
        return new class_243((double)view.x(), (double)view.y(), (double)view.z()).method_1029();
    }

    public static class_243 getMouseLookVector(float mouseX, float mouseY) {
        return EditorUI.getMouseLookVectorFromForwards(EditorUI.getMouseForwardsVector(mouseX, mouseY));
    }

    public static class_243 getMouseLookVector() {
        return EditorUI.getMouseLookVectorFromForwards(EditorUI.getMouseForwardsVector());
    }

    public static void clearActiveBlockHistory() {
        activeBlockHistory.clear();
    }

    public static class_2680 getActiveBlock() {
        return activeBlockHistory.getActive().getVanillaState();
    }

    public static boolean isMovingCamera() {
        return movementControls != EditorMovementControls.none() || imguiGlfw.isGrabbed() && imguiGlfw.getMouseHandledBy() == CustomImGuiImplGlfw.MouseHandledBy.GAME;
    }

    public static boolean allowGameInputWhileCaptureKeyboard() {
        return movementControls.allowGameInputWhileCaptureKeyboard();
    }

    public static void setupMainViewport() {
        class_1041 window = class_310.method_1551().method_22683();
        int frameBottom = window.field_5197 - (frameY + frameHeight);
        GlStateManager._viewport((int)(frameX * window.method_4489() / window.method_4480()), (int)(frameBottom * window.method_4506() / window.method_4507()), (int)Math.max(1, frameWidth * window.method_4489() / window.method_4480()), (int)Math.max(1, frameHeight * window.method_4506() / window.method_4507()));
    }

    public static float getUiScale() {
        return globalScale * contentScale;
    }

    public static double getNewMouseX(double x) {
        return x - (double)frameX;
    }

    public static double getNewMouseY(double y) {
        return y - (double)frameY;
    }

    public static int getNewGameWidth(float scale) {
        return Math.max(1, Math.round((float)frameWidth * scale));
    }

    public static int getNewGameHeight(float scale) {
        return Math.max(1, Math.round((float)frameHeight * scale));
    }

    private static boolean isActiveInternal() {
        class_746 player = class_310.method_1551().field_1724;
        return AxiomClient.isAxiomActive(class_1934.field_9219) && enabled && class_310.method_1551().field_1687 != null && player != null && player == class_310.method_1551().method_1560() && Restrictions.canUseEditor;
    }

    public static void enable() {
        class_746 player = class_310.method_1551().field_1724;
        if (!Restrictions.canUseEditor) {
            player.method_7353((class_2561)class_2561.method_43470((String)"The server has disallowed the use of the editor").method_27692(class_124.field_1061), false);
        }
        ServerIntegration.changeGameMode(class_1934.field_9219);
        if (ServerIntegration.getGameType() == class_1934.field_9219) {
            enabled = true;
            inventoryOverrides.clear();
            if (Configuration.capabilities.separateEditorAndGameFlightSpeed && player != null) {
                savedGameFlightSpeed = player.method_31549().method_7252();
                if (savedEditorFlightSpeed > 0.0f) {
                    ServerIntegration.changeFlySpeed(savedEditorFlightSpeed);
                }
            }
        }
    }

    public static void disable() {
        enabled = false;
        ServerIntegration.changeGameMode(class_1934.field_9220);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            inventoryOverrides.clear();
            return;
        }
        if (ServerIntegration.getGameType() == class_1934.field_9220) {
            for (Int2ObjectMap.Entry entry : inventoryOverrides.int2ObjectEntrySet()) {
                player.method_31548().method_5447(entry.getIntKey(), (class_1799)entry.getValue());
                int index = entry.getIntKey();
                if (index < 9) {
                    index += 36;
                }
                ServerIntegration.sendPacketAfterUpdates(new class_2873(index, (class_1799)entry.getValue()));
            }
            inventoryOverrides.clear();
        }
        if (Configuration.capabilities.separateEditorAndGameFlightSpeed) {
            savedEditorFlightSpeed = player.method_31549().method_7252();
            if (savedGameFlightSpeed > 0.0f) {
                ServerIntegration.changeFlySpeed(savedGameFlightSpeed);
            }
        }
    }

    public static void toggleEnabled() {
        if (enabled) {
            EditorUI.disable();
        } else {
            EditorUI.enable();
        }
    }

    public static void deferredCloseTextureId(int textureId) {
        deferredCloseLock.lock();
        try {
            deferredCloseTextureIds.add(textureId);
        }
        finally {
            deferredCloseLock.unlock();
        }
    }

    public static void deferredClose(AutoCloseable autoCloseable) {
        deferredCloseLock.lock();
        try {
            deferredClose.add(autoCloseable);
        }
        finally {
            deferredCloseLock.unlock();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isActive() {
        return activeLastFrame;
    }

    private static void transitionActiveState(boolean active) {
        if (activeLastFrame == active) {
            return;
        }
        activeLastFrame = active;
        class_1041 window = class_310.method_1551().method_22683();
        if (window.method_4489() > 0 && window.method_4489() <= 32768 && window.method_4506() > 0 && window.method_4506() <= 32768) {
            class_310.method_1551().method_15993();
        }
        imguiGlfw.ungrab();
        if (!activeLastFrame) {
            if (class_310.method_1551().field_1761 != null) {
                if (class_310.method_1551().field_1755 == null) {
                    class_310.method_1551().field_1729.method_1610();
                    class_310.method_1551().field_1729.method_1612();
                } else {
                    class_310.method_1551().field_1729.method_1612();
                    class_310.method_1551().field_1729.method_1610();
                }
                class_310.method_1551().field_1729.method_1599();
            }
        } else {
            long handle = ImGui.getMainViewport().getPlatformHandle();
            if (GLFW.glfwGetInputMode((long)handle, (int)208897) != 212993) {
                GLFW.glfwSetInputMode((long)handle, (int)208897, (int)212993);
                GLFW.glfwSetCursorPos((long)handle, (double)(ImGui.getMainViewport().getSizeX() / 2.0f), (double)(ImGui.getMainViewport().getSizeY() / 2.0f));
            }
        }
        imguiGlfw.setViewportWindowsHidden(!activeLastFrame);
        ServerIntegration.syncFlySpeed();
        BuilderToolManager.setToolSlotActive(false);
        Placement.INSTANCE.updateCutout();
    }

    public static boolean hasImGuiContext() {
        return imGuiContext != null;
    }

    public static boolean isImGuiContextActive() {
        return imGuiContext != null && isContextActive;
    }

    public static long pushImGuiContext() {
        isContextActive = true;
        long oldImGuiContext = ImGui.getCurrentContext().ptr;
        ImGui.setCurrentContext(imGuiContext);
        return oldImGuiContext;
    }

    public static void popImGuiContext(long oldContext) {
        isContextActive = imGuiContext != null && oldContext == EditorUI.imGuiContext.ptr;
        ImGuiContext currentContext = ImGui.getCurrentContext();
        currentContext.ptr = oldContext;
        ImGui.setCurrentContext(currentContext);
    }

    public static void drawOverlay() {
        if (!StaticValues.gameHasTicked) {
            return;
        }
        GlStateManager._disableColorLogicOp();
        long oldImGuiContext = EditorUI.pushImGuiContext();
        try {
            EditorUI.drawOverlayInternal();
        }
        finally {
            EditorUI.popImGuiContext(oldImGuiContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawOverlayInternal() {
        int oldFrameX = frameX;
        int oldFrameY = frameY;
        int oldFrameWidth = frameWidth;
        int oldFrameHeight = frameHeight;
        viewportX = ImGui.getMainViewport().getPosX();
        viewportY = ImGui.getMainViewport().getPosY();
        if (!initialized) {
            throw new IllegalStateException("Tried to use EditorUI while it was not initialized");
        }
        deferredCloseLock.lock();
        try {
            IntListIterator intListIterator = deferredCloseTextureIds.iterator();
            while (intListIterator.hasNext()) {
                int id = (Integer)intListIterator.next();
                GlStateManager._deleteTexture((int)id);
            }
            deferredCloseTextureIds.clear();
            for (AutoCloseable closeable : deferredClose) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
            }
            deferredClose.clear();
        }
        finally {
            deferredCloseLock.unlock();
        }
        if (class_310.method_1551().field_1755 instanceof class_435 || class_310.method_1551().field_1755 instanceof class_434) {
            return;
        }
        if (!EditorUI.isActiveInternal()) {
            pendingDepthActions.clear();
            EditorUI.transitionActiveState(false);
            if (!AxiomClient.isAxiomActive(class_1934.field_9219)) {
                enabled = false;
            }
            imguiGlfw.updateReleaseAllKeys(true);
            if (ImageReferenceWindows.hasReferenceInGameUI()) {
                long oldImGuiContext = EditorUI.pushImGuiContext();
                imguiGlfw.newFrame();
                ImGui.newFrame();
                ImageReferenceWindows.render();
                ImGui.render();
                ImGuiHelper.endFrame();
                long ctx = GLFW.glfwGetCurrentContext();
                ImGui.updatePlatformWindows();
                ImGui.renderPlatformWindowsDefault();
                GLFW.glfwMakeContextCurrent((long)ctx);
                ImDrawData drawData = ImGui.getDrawData();
                if (drawData != null) {
                    imguiGl3.renderDrawData(drawData);
                }
                EditorUI.popImGuiContext(oldImGuiContext);
            }
            return;
        }
        imguiGlfw.updateReleaseAllKeys(false);
        if (WorldRenderHook.hasDistance) {
            for (PendingDepthAction pendingDepthAction : pendingDepthActions) {
                if (pendingDepthAction == PendingDepthAction.ARCBALL) {
                    int key;
                    movementControls = EditorMovementControls.arcballFromDepth();
                    if (movementControls == EditorMovementControls.none() || (key = Keybinds.ARCBALL_CAMERA.getKey()) == 0) continue;
                    imguiGlfw.setGrabbed(false, key, (float)frameX + (float)frameWidth / 2.0f, (float)frameY + (float)frameHeight / 2.0f);
                    continue;
                }
                if (pendingDepthAction == PendingDepthAction.PAN) {
                    movementControls = EditorMovementControls.pan();
                    continue;
                }
                int wheelY = pendingDepthAction == PendingDepthAction.SCROLL_POSITIVE ? 1 : -1;
                class_746 entity = class_310.method_1551().field_1724;
                class_243 forwards = EditorUI.getMouseForwardsVector();
                if (entity == null || forwards == null) continue;
                Vector3f view = forwards.method_46409().rotate((Quaternionfc)lastViewQuaternion).normalize();
                class_243 pos = entity.method_19538();
                double length = WorldRenderHook.distance * 0.05f;
                if (length > 4.0) {
                    length = 4.0f + (float)Math.sqrt(length - 4.0);
                }
                if (length < (double)0.4f) {
                    length = 0.4f;
                }
                length *= (double)wheelY;
                if (EditorUI.isMoveQuickDown()) {
                    length *= 2.0;
                }
                entity.method_33574(pos.method_1019(new class_243(view).method_18805(length, length, length)));
            }
        }
        pendingDepthActions.clear();
        double grabbedMouseDeltaX = imguiGlfw.getGrabbedMouseDeltaX();
        double grabbedMouseDeltaY = imguiGlfw.getGrabbedMouseDeltaY();
        if (movementControls.shouldStop(imguiGlfw.isGrabbed())) {
            movementControls = EditorMovementControls.none();
        } else {
            movementControls.update(grabbedMouseDeltaX, grabbedMouseDeltaY);
        }
        if (!ImGui.isAnyMouseDown()) {
            float newContentScale;
            if ((double)(newGlobalScale = (float)((int)(newGlobalScale * 16.0f)) / 16.0f) < 0.25) {
                newGlobalScale = 0.25f;
            }
            if (newGlobalScale > 4.0f) {
                newGlobalScale = 4.0f;
            }
            if ((double)(newContentScale = (float)((int)(EditorUI.imguiGlfw.contentScale * 16.0f)) / 16.0f) < 0.125) {
                newContentScale = 0.125f;
            }
            if (newContentScale > 8.0f) {
                newContentScale = 8.0f;
            }
            if (globalScale != newGlobalScale || contentScale != newContentScale) {
                int oldFontSize = (int)(16.0f * EditorUI.getUiScale());
                globalScale = newGlobalScale;
                contentScale = newContentScale;
                if (oldFontSize != (int)(16.0f * EditorUI.getUiScale())) {
                    Axiom.dbg("Resizing EditorUI fonts from: " + oldFontSize + " to: " + (int)(16.0f * EditorUI.getUiScale()));
                    EditorUI.initFonts(languageCode);
                }
            }
        }
        imguiGlfw.newFrame();
        ImGui.newFrame();
        canProcessKeybinds = !ImGui.isPopupOpen("", 384) && !EditorUI.getIO().getWantTextInput() && !ImGuiHelper.getWantsSpecialInput() && !EditorWindowType.KEYBINDS.isOpen();
        boolean bl = navClose = EditorUI.getIO().getNavInputs(1) != 0.0f;
        if (wasNavClose != navClose) {
            wasNavClose = navClose;
        } else if (wasNavClose) {
            navClose = false;
        }
        if (ImGui.isPopupOpen("", 384)) {
            EditorUI.getIO().addConfigFlags(1);
        } else {
            EditorUI.getIO().removeConfigFlags(1);
        }
        char controlIcon = class_310.field_1703 ? (char)'\u2318' : '\u2303';
        MainMenuBar.render();
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImVec2 workPos = viewport.getWorkPos();
        ImVec2 workSize = viewport.getWorkSize();
        float sizeX = workSize.x;
        float sizeY = Math.min(workSize.y, ImGui.getFrameHeight());
        float f = workPos.x;
        float posY = workPos.y + workSize.y - sizeY;
        viewport.setWorkSize(workSize.x, workSize.y - sizeY);
        ImGui.setNextWindowViewport(viewport.getID());
        ImGui.setNextWindowPos(f, posY);
        ImGui.setNextWindowSize(sizeX, sizeY);
        if (ImGui.begin("##MainStatusBar", 1295) && ImGui.beginMenuBar()) {
            ArrayList<CallSite> hintsToShow = new ArrayList<CallSite>();
            boolean holdCtrlForMoreOptions = false;
            if (ToolManager.isToolActive()) {
                String esc = ToolManager.getCurrentTool().listenForEsc();
                String enter = ToolManager.getCurrentTool().listenForEnter();
                if (esc != null) {
                    hintsToShow.add((CallSite)((Object)(AxiomI18n.get("axiom.editorui.escape_key") + " - " + esc)));
                }
                if (enter != null) {
                    hintsToShow.add((CallSite)((Object)(AxiomI18n.get("axiom.editorui.enter_key") + " - " + enter)));
                }
            }
            if (hintsToShow.isEmpty()) {
                String rmb;
                String mmb;
                String lmb;
                Set<Keybind> left = Keybinds.keybindsForKey.get(-1);
                Set<Keybind> middle = Keybinds.keybindsForKey.get(-3);
                Set<Keybind> set = Keybinds.keybindsForKey.get(-2);
                if (EditorUI.isCtrlOrCmdDown()) {
                    lmb = EditorUI.getPrioritizedKeybind(left, true);
                    mmb = EditorUI.getPrioritizedKeybind(middle, true);
                    rmb = EditorUI.getPrioritizedKeybind(set, true);
                } else {
                    lmb = EditorUI.getPrioritizedKeybind(left, false);
                    mmb = EditorUI.getPrioritizedKeybind(middle, false);
                    rmb = EditorUI.getPrioritizedKeybind(set, false);
                }
                hintsToShow.add((CallSite)((Object)(AxiomI18n.get("axiom.editorui.left_mouse_short") + " - " + lmb)));
                hintsToShow.add((CallSite)((Object)(AxiomI18n.get("axiom.editorui.middle_mouse_short") + " - " + mmb)));
                hintsToShow.add((CallSite)((Object)(AxiomI18n.get("axiom.editorui.right_mouse_short") + " - " + rmb)));
                holdCtrlForMoreOptions = true;
            }
            float offset = 150.0f;
            for (String string : hintsToShow) {
                offset = Math.max(offset, ImGuiHelper.calcTextWidth(string));
            }
            offset += 50.0f;
            for (int i = 0; i < hintsToShow.size(); ++i) {
                ImGui.text((String)hintsToShow.get(i));
                ImGui.sameLine(offset * (float)(1 + i));
                ImGui.separator();
            }
            int selectedBlocks = Selection.selectedBlockCount();
            if (selectedBlocks > 0) {
                ImGui.text(AxiomI18n.get("axiom.history_description.selected", NumberFormat.getInstance().format(selectedBlocks)));
            } else if (!EditorUI.isCtrlOrCmdDown() && holdCtrlForMoreOptions) {
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.hold_for_more_options", Character.valueOf(controlIcon)));
            }
            boolean bl2 = ToolManager.isToolActive() && ToolManager.getCurrentTool().showToolSmoothing();
            boolean showTeleport = !ClientEvents.teleportablePlayers.isEmpty();
            float sliderWidth = 150.0f * EditorUI.getUiScale();
            String toolSmoothingText = AxiomI18n.get("axiom.editorui.tool_stabilization");
            String speedText = AxiomI18n.get("axiom.editorui.speed");
            String teleport = AxiomI18n.get("axiom.editorui.teleport");
            float speedWidth = ImGuiHelper.calcTextWidth(speedText);
            float start = ImGui.getWindowWidth() - sliderWidth - ImGui.getStyle().getItemSpacingX() - speedWidth - 1.0f;
            if (bl2) {
                float toolSmoothingWidth = ImGuiHelper.calcTextWidth(toolSmoothingText);
                start -= toolSmoothingWidth + sliderWidth + ImGui.getStyle().getItemSpacingX() * 3.0f;
            }
            if (showTeleport) {
                float teleportWidth = ImGuiHelper.calcTextWidth(teleport);
                start -= teleportWidth + ImGui.getStyle().getItemSpacingX() * 3.0f;
            }
            ImGui.setCursorPosX(start);
            if (bl2) {
                ImGui.text(toolSmoothingText);
                ImGui.setNextItemWidth(sliderWidth);
                float[] toolSmoothing = new float[]{(float)Configuration.keybind.toolSmoothSteps * 0.1f};
                ImGui.sliderFloat("##ToolSmoothingSlider", toolSmoothing, 0.0f, 16.0f, "%.1f");
                Configuration.keybind.toolSmoothSteps = Math.round(toolSmoothing[0] * 10.0f);
                ImGui.separator();
            }
            if (showTeleport) {
                if (ImGui.menuItem(teleport)) {
                    ImGui.openPopup("##TeleportToPlayers");
                }
                ImGui.separator();
            }
            if (ImGui.beginPopup("##TeleportToPlayers")) {
                for (class_640 player : ClientEvents.teleportablePlayers) {
                    String name = player.method_2966().getName();
                    if (!ImGui.menuItem(name)) continue;
                    class_310.method_1551().method_1562().method_45731("tp " + String.valueOf(player.method_2966().getId()));
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
            ImGui.text(speedText);
            ImGui.setNextItemWidth(sliderWidth);
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                class_1656 abilities = player.method_31549();
                float flyingSpeed = abilities.method_7252() / 0.05f;
                float[] speed = new float[]{flyingSpeed};
                if (ImGui.sliderFloat("##FlightSpeedSlider", speed, 1.0f, 10.0f, "%.2f") && speed[0] != flyingSpeed) {
                    ServerIntegration.changeFlySpeed(speed[0] * 0.05f);
                }
            } else {
                ImGui.sliderFloat("##FlightSpeedSlider", new float[]{1.0f}, 1.0f, 10.0f);
            }
            ImGui.endMenuBar();
        }
        ImGui.end();
        ImGui.setNextWindowBgAlpha(0.0f);
        int mainDock = ImGui.dockSpaceOverViewport(ImGui.getMainViewport(), 4);
        imgui.internal.ImGui.dockBuilderGetCentralNode(mainDock).addLocalFlags(4096);
        isFrameHovered = false;
        ImGui.setNextWindowDockID(mainDock);
        ImGuiHelper.pushStyleVar(2, 0.0f, 0.0f);
        float titleBarHeight = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f;
        boolean fireCancelNavInput = false;
        if (ImGui.begin("Main", 131502)) {
            TutorialStage currentStage;
            ImGuiHelper.popStyleVar();
            float startY = ImGui.getCursorScreenPosY();
            ServerConfig serverConfig = Axiom.getInstance().serverConfig;
            if (serverConfig != null) {
                ImGui.pushID("Views");
                List<View> views = ViewManager.getViews();
                ImDrawList backgroundDrawList = ImGui.getBackgroundDrawList();
                float cursorScreenPosX = ImGui.getCursorScreenPosX();
                float cursorScreenPosY = ImGui.getCursorScreenPosY();
                float tabBarHeight = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f;
                backgroundDrawList.addRectFilled(cursorScreenPosX, cursorScreenPosY, cursorScreenPosX + ImGui.getWindowWidth(), cursorScreenPosY + tabBarHeight, ImGui.getColorU32(10));
                ImGui.beginTabBar("##Bar", 3);
                if (serverConfig.editableEditorViews() && views.size() < serverConfig.maximumEditorViews()) {
                    ImGuiHelper.pushStyleVar(12, ImGui.getStyle().getTabRounding());
                    if (ImGui.tabItemButton("+", 128)) {
                        ViewManager.addNewView();
                    }
                    ImGuiHelper.popStyleVar();
                }
                int removeView = -1;
                for (int i = 0; i < views.size(); ++i) {
                    View view = views.get(i);
                    int flags = focusViewNextFrame == i ? 2 : 0;
                    ImBoolean open = new ImBoolean(true);
                    boolean tabActive = views.size() == 1 || !serverConfig.editableEditorViews() ? ImGui.beginTabItem(view.name + "###" + String.valueOf(view.uuid), flags) : ImGui.beginTabItem(view.name + "###" + String.valueOf(view.uuid), open, flags);
                    if (ImGui.isItemClicked(0)) {
                        view.teleportPinned((class_1657)class_310.method_1551().field_1724);
                    }
                    boolean openRename = false;
                    if (ImGui.isItemClicked(1)) {
                        if (serverConfig.editableEditorViews()) {
                            ImGui.openPopup("##" + String.valueOf(view.uuid) + "Edit");
                        } else {
                            openRename = true;
                        }
                    }
                    if (ImGuiHelper.beginPopup("##" + String.valueOf(view.uuid) + "Edit")) {
                        if (!serverConfig.editableEditorViews()) {
                            ImGui.closeCurrentPopup();
                        } else {
                            ImGui.text(view.name);
                            ImGui.separator();
                            if (ImGui.menuItem(AxiomI18n.get("axiom.widget.rename"))) {
                                openRename = true;
                                ImGui.closeCurrentPopup();
                            }
                            if (views.size() > 1 && ImGui.menuItem(AxiomI18n.get("axiom.widget.delete"))) {
                                open.set(false);
                                ImGui.closeCurrentPopup();
                            }
                            ImGui.separator();
                            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.pin_world"), view.pinLevel)) {
                                view.pinLevel = !view.pinLevel;
                                ViewManager.dirty();
                            }
                            if (!view.pinLevel) {
                                ImGui.beginDisabled();
                            }
                            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.pin_location"), view.pinLevel && view.pinLocation)) {
                                view.pinLocation = !view.pinLocation;
                                ViewManager.dirty();
                            }
                            if (!view.pinLevel) {
                                ImGui.endDisabled();
                            }
                        }
                        ImGui.endPopup();
                    }
                    if (openRename) {
                        ImGui.openPopup("##" + String.valueOf(view.uuid) + "Rename");
                    }
                    if (ImGuiHelper.beginPopup("##" + String.valueOf(view.uuid) + "Rename")) {
                        ImString string = new ImString(view.name, 64);
                        ImGui.setKeyboardFocusHere();
                        if (ImGui.inputText("##Input", string)) {
                            view.name = ImGuiHelper.getString(string);
                        }
                        if (ImGui.isItemDeactivatedAfterEdit()) {
                            ImGui.closeCurrentPopup();
                            ViewManager.dirty();
                        }
                        ImGui.endPopup();
                    }
                    if (tabActive) {
                        view.markActive((class_1657)class_310.method_1551().field_1724);
                        ImGui.endTabItem();
                    } else {
                        view.markInactive();
                    }
                    if (open.get()) continue;
                    removeView = i;
                }
                if (removeView != -1 && views.size() > 1 && serverConfig.editableEditorViews()) {
                    views.remove(removeView);
                }
                ImGui.endTabBar();
                ImGui.popID();
            }
            float minX = ImGui.getWindowContentRegionMinX();
            float maxX = ImGui.getWindowContentRegionMaxX();
            float minY = ImGui.getWindowContentRegionMinY() + titleBarHeight;
            float maxY = ImGui.getWindowContentRegionMaxY();
            if (EditorUI.getIO().hasConfigFlags(1024)) {
                frameX = (int)(ImGui.getWindowPosX() - ImGui.getWindowViewport().getPosX() + minX);
                frameY = (int)(ImGui.getWindowPosY() - ImGui.getWindowViewport().getPosY() + minY);
            } else {
                frameX = (int)(ImGui.getWindowPosX() + minX);
                frameY = (int)(ImGui.getWindowPosY() + minY);
            }
            frameWidth = (int)Math.max(1.0f, maxX - minX);
            frameHeight = (int)Math.max(1.0f, maxY - minY);
            viewportSizeX = (int)ImGui.getMainViewport().getSizeX();
            viewportSizeY = (int)ImGui.getMainViewport().getSizeY();
            if (frameX != oldFrameX || frameY != oldFrameY || frameWidth != oldFrameWidth || frameHeight != oldFrameHeight) {
                class_1041 window = class_310.method_1551().method_22683();
                ((WindowExt)window).axiom$refreshFramebufferSize();
                int[] width = new int[1];
                int[] height = new int[1];
                GLFW.glfwGetWindowSize((long)window.method_4490(), (int[])width, (int[])height);
                if (width[0] > 0 && height[0] > 0) {
                    ((WindowExt)window).axiom$resize(window.method_4490(), width[0], height[0]);
                }
                class_310.method_1551().method_15993();
            }
            if (!Selection.getSelectionBuffer().isEmpty()) {
                Tutorial.SELECTION.initiateIfNotCompleted();
            }
            if ((currentStage = TutorialManager.getCurrentStage()) != null && currentStage.getLinkedWindow() == null) {
                ImGui.setNextWindowPos((float)frameX + (float)frameWidth * 0.5f, (float)frameY + (float)frameHeight * 0.25f, 1, 0.5f, 0.5f);
                currentStage.render();
            } else if (ClientEvents.updateMessage != null) {
                ImGui.setNextWindowPos((float)frameX + (float)frameWidth * 0.5f, (float)frameY + (float)frameHeight * 0.75f, 1, 0.5f, 0.5f);
                ImGui.setNextWindowSizeConstraints(550.0f, 0.0f, 550.0f, (float)frameHeight * 0.45f);
                ImGuiHelper.pushStyleVar(4, 2.0f);
                ImGuiHelper.pushStyleColor(5, -16711681);
                if (ImGui.begin("##UpdatePopup", 2101603)) {
                    ImGui.pushTextWrapPos();
                    ImGui.text(ClientEvents.updateMessage);
                    ImGui.popTextWrapPos();
                    if (ImGui.button(AxiomI18n.get("axiom.editorui.update"))) {
                        try {
                            class_156.method_668().method_673(new URI("https://axiom.moulberry.com/download"));
                        }
                        catch (Exception width) {
                            // empty catch block
                        }
                        ClientEvents.updateMessage = null;
                        Configuration.internal.nextUpdateNag = System.currentTimeMillis() + ChronoUnit.DAYS.getDuration().getSeconds() * 3000L;
                    }
                    ImGui.sameLine();
                    if (ImGui.button(AxiomI18n.get("axiom.editorui.skip_update"))) {
                        ClientEvents.updateMessage = null;
                        Configuration.internal.nextUpdateNag = System.currentTimeMillis() + ChronoUnit.DAYS.getDuration().getSeconds() * 3000L;
                    }
                }
                ImGui.end();
                ImGuiHelper.popStyleColor();
                ImGuiHelper.popStyleVar();
            }
            if (!warnings.isEmpty()) {
                EditorWarningType type2 = (EditorWarningType)((Object)warnings.iterator().next());
                switch (type2) {
                    case SPECTATORS_GENERATE_CHUNKS: {
                        ImGui.setNextWindowPos((float)frameX + (float)frameWidth * 0.5f, (float)frameY + (float)frameHeight * 0.75f, 1, 0.5f, 0.5f);
                        ImGui.setNextWindowSize(350.0f, 0.0f);
                        if (ImGui.begin("##WarningPopup", 2101611)) {
                            ImGui.pushTextWrapPos();
                            ImGui.textColored(-7829249, AxiomI18n.get("axiom.editorui.spectators_generate_chunks_warning"));
                            ImGui.popTextWrapPos();
                        }
                        ImGui.end();
                    }
                }
            }
            if (!Configuration.keybind.pickBlockDrag) {
                draggingBlockFromWorld = null;
            } else {
                CustomBlockState customBlockState;
                ImGui.setCursorScreenPos(ImGui.getCursorScreenPosX() + 8.0f, startY + titleBarHeight + 8.0f);
                int leftClickId = -1;
                int middleClickId = -3;
                int rightClickId = -2;
                int pickBlockId = Keybinds.PICK_BLOCK.getKey();
                if (!(pickBlockId != leftClickId && pickBlockId != middleClickId && pickBlockId != rightClickId || draggingBlockFromWorld == null && !Keybinds.PICK_BLOCK.areAllModifiersDown())) {
                    boolean stopDragging;
                    int buttonFlags = 4;
                    if (pickBlockId == leftClickId) {
                        buttonFlags = 0;
                    } else if (pickBlockId == rightClickId) {
                        buttonFlags = 2;
                    }
                    if (ImGui.invisibleButton("##WorldDragDrop", frameWidth - 16, frameHeight - 16, buttonFlags)) {
                        isFrameHovered = true;
                        RayCaster.RaycastResult result = Tool.raycastBlock();
                        if (result != null) {
                            class_2680 blockState = class_310.method_1551().field_1687.method_8320(result.blockPos());
                            CustomBlockState customBlockState2 = ServerCustomBlocks.getCustomStateFor(blockState);
                            activeBlockHistory.setActive(Objects.requireNonNullElse(customBlockState2, (CustomBlockState)blockState));
                        }
                    }
                    boolean bl3 = stopDragging = !Keybinds.PICK_BLOCK.isDown();
                    if (ImGui.beginDragDropSource()) {
                        if (draggingBlockFromWorld == null) {
                            isFrameHovered = true;
                            RayCaster.RaycastResult result = Tool.raycastBlock();
                            if (result != null) {
                                class_2680 blockState = class_310.method_1551().field_1687.method_8320(result.blockPos());
                                customBlockState = ServerCustomBlocks.getCustomStateFor(blockState);
                                draggingBlockFromWorld = Objects.requireNonNullElse(customBlockState, (CustomBlockState)blockState);
                            }
                        }
                        if (draggingBlockFromWorld != null) {
                            ImGui.setDragDropPayload("BlockState", draggingBlockFromWorld);
                            ImGuiHelper.drawBlockState(ImGui.getForegroundDrawList(), draggingBlockFromWorld, ImGui.getCursorScreenPosX(), ImGui.getCursorScreenPosY(), 32.0f);
                            ImGui.dummy(32.0f, 32.0f);
                            stopDragging = false;
                        }
                        ImGui.endDragDropSource();
                    }
                    if (stopDragging) {
                        draggingBlockFromWorld = null;
                    }
                }
                ImGui.setCursorScreenPos(ImGui.getCursorScreenPosX() + 8.0f, startY + titleBarHeight + 8.0f);
                ImGui.dummy(frameWidth - 16, frameHeight - 16);
                if (ImGui.beginDragDropTarget()) {
                    List<Object> blockStates;
                    EditorPalette droppedPalette = ImGui.acceptDragDropPayload(EditorPalette.class);
                    if (droppedPalette != null) {
                        blockStates = new ArrayList();
                        for (CustomBlockStateOrTombstone block : droppedPalette.getBlocks()) {
                            if (!(block instanceof CustomBlockState)) continue;
                            customBlockState = (CustomBlockState)block;
                            blockStates.add(customBlockState);
                        }
                    } else {
                        DragDropPayloads.PaletteBlock droppedPaletteBlock;
                        CustomBlockState droppedBlockState = (CustomBlockState)ImGui.acceptDragDropPayload("BlockState");
                        blockStates = droppedBlockState != null ? List.of(droppedBlockState) : ((droppedPaletteBlock = ImGui.acceptDragDropPayload(DragDropPayloads.PaletteBlock.class)) != null ? List.of(droppedPaletteBlock.state()) : List.of());
                    }
                    if (!blockStates.isEmpty()) {
                        class_638 level;
                        isFrameHovered = true;
                        RayCaster.RaycastResult result = Tool.raycastBlock(true, true, true);
                        if (result != null && (level = class_310.method_1551().field_1687) != null) {
                            if (result.isSelection()) {
                                if (blockStates.size() == 1) {
                                    FillOperation.fill(((CustomBlockState)blockStates.get(0)).getVanillaState());
                                } else {
                                    ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                                    ThreadLocalRandom random2 = ThreadLocalRandom.current();
                                    Selection.getSelectionBuffer().forEach((x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, ((CustomBlockState)blockStates.get(random2.nextInt(0, blockStates.size()))).getVanillaState()));
                                    chunkedBlockRegion.dirtyAll();
                                    String countString = NumberFormat.getInstance().format(Selection.getSelectionBuffer().size());
                                    String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
                                    RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, Dispatcher.simpleSourceInfo("Dragdrop Fill"));
                                }
                            } else {
                                class_2680 block = level.method_8320(result.blockPos());
                                if (!(block.method_26215() || blockStates.size() == 1 && block == ((CustomBlockState)blockStates.get(0)).getVanillaState())) {
                                    ChunkedBooleanRegion region = new ChunkedBooleanRegion();
                                    MagicSelectionFast.MagicSelectionTask task = new MagicSelectionFast.MagicSelectionTask(region, (class_1937)level, result.blockPos());
                                    task.fill(10000000);
                                    if (blockStates.size() == 1) {
                                        String countString = NumberFormat.getInstance().format(region.count());
                                        String blockName = AxiomI18n.get(((CustomBlockState)blockStates.get(0)).getCustomBlock().axiom$translationKey());
                                        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
                                        RegionHelper.pushBooleanRegionChange(region, ((CustomBlockState)blockStates.get(0)).getVanillaState(), historyDescription, Dispatcher.simpleSourceInfo("Dragdrop Fill"));
                                    } else {
                                        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                                        ThreadLocalRandom random3 = ThreadLocalRandom.current();
                                        region.forEach((x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, ((CustomBlockState)blockStates.get(random3.nextInt(blockStates.size()))).getVanillaState()));
                                        chunkedBlockRegion.dirtyAll();
                                        String countString = NumberFormat.getInstance().format(region.count());
                                        String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
                                        RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, Dispatcher.simpleSourceInfo("Dragdrop Fill"));
                                    }
                                    region.close();
                                }
                            }
                        }
                    }
                    ImGui.endDragDropTarget();
                }
            }
            if (ImGui.isWindowHovered() && imGuiIO.getMousePosY() > ImGui.getWindowPosY() + titleBarHeight) {
                isFrameHovered = true;
                if (class_310.method_1551().field_1755 != null) {
                    ImGui.captureMouseFromApp(false);
                } else {
                    int wheelY;
                    boolean adjustSpeed = Keybinds.ADJUST_SPEED.isDownUsingGLFW();
                    if (adjustSpeed && (wheelY = (int)Math.signum(EditorUI.getIO().getMouseWheel())) != 0) {
                        class_1656 abilities = class_310.method_1551().field_1724.method_31549();
                        ServerIntegration.changeFlySpeed(class_3532.method_15363((float)(abilities.method_7252() + (float)wheelY * 0.01f), (float)0.05f, (float)0.5f));
                        class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Set fly speed to: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2fx", Float.valueOf(abilities.method_7252() * 20.0f))).method_27692(class_124.field_1060)), false);
                    }
                    if (EditorUI.getIO().getWantCaptureMouse() && !EditorUI.isMovingCamera()) {
                        if (!adjustSpeed) {
                            EditorUI.handleScroll();
                        }
                        fireCancelNavInput |= EditorUI.handleBasicInputs();
                    }
                }
            }
        } else {
            ImGuiHelper.popStyleVar();
        }
        ImGui.end();
        if (adjustingTool) {
            if (!imguiGlfw.isGrabbed()) {
                adjustingTool = false;
                adjustingToolOffsetX = 0.0f;
                adjustingToolOffsetY = 0.0f;
            } else if (!ToolManager.isToolActive()) {
                imguiGlfw.ungrab();
                adjustingTool = false;
                adjustingToolOffsetX = 0.0f;
                adjustingToolOffsetY = 0.0f;
            } else {
                class_241 offset;
                float mouseX = imGuiIO.getMousePosX();
                float f2 = imGuiIO.getMousePosY();
                adjustingToolOffsetX = (float)((double)adjustingToolOffsetX + grabbedMouseDeltaX);
                adjustingToolOffsetY = (float)((double)adjustingToolOffsetY + grabbedMouseDeltaY);
                Tool tool = ToolManager.getCurrentTool();
                class_241 result = tool.renderAdjustment(mouseX, f2, offset = new class_241(adjustingToolOffsetX, adjustingToolOffsetY));
                if (result != offset) {
                    adjustingToolOffsetX = result.field_1343;
                    adjustingToolOffsetY = result.field_1342;
                }
            }
        }
        ToolsWindow.render(icons);
        ToolOptionsWindow.render();
        ClipboardInstallationWindow.render();
        TargetInfoWindow.render();
        WorldPropertiesWindow.render();
        HistoryWindow.render();
        ClipboardWindow.render();
        PlacementOptionsOverlay.render(frameX + frameWidth, frameY);
        PaletteWindow.render(activeBlockHistory, blockList);
        InventoryWindow.render(activeBlockHistory, blockList);
        CurrentBlockWindow.render(activeBlockHistory, blockList);
        TextAnnotationListWindow.render();
        BlueprintCreateWindow.render();
        BlueprintBrowserWindow.render();
        MaskSelectionWindow.render(blockList);
        ExpandSelectionWindow.render();
        ShrinkSelectionWindow.render();
        DistortSelectionWindow.render();
        SmoothSelectionWindow.render();
        FillBlocksWindow.render(blockList);
        ReplaceBlocksWindow.render(blockList);
        TypeReplaceBlocksWindow.render(blockList);
        SetBiomeWindow.render();
        AutoshadeWindow.render();
        QuickFillWindow.render(blockList);
        QuickReplaceWindow.render(blockList);
        AnalyzeBlocksWindow.render();
        AnimatedRebuildWindow.render();
        KeybindsWindow.render();
        ToolMaskWindow.render();
        DebugInfoWindow.render();
        StyleEditorWindow.render();
        RotatePlacementWindow.render();
        ExportSchematicWindow.render();
        ImageReferenceWindows.render();
        focusViewNextFrame = -1;
        boolean bl4 = canProcessKeybinds = !ImGui.isPopupOpen("", 384) && !EditorUI.getIO().getWantTextInput() && !ImGuiHelper.getWantsSpecialInput() && !EditorWindowType.KEYBINDS.isOpen();
        if (canProcessKeybinds) {
            IntOpenHashSet usedKeys = new IntOpenHashSet();
            if (Keybinds.COPY.isPressed(false) && UserAction.COPY.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.COPY.getKey());
            }
            if (!usedKeys.contains(Keybinds.COPY_WITH_AIR.getKey()) && Keybinds.COPY_WITH_AIR.isPressed(false)) {
                Selection.makeNextCopyIncludeAir = true;
                if (UserAction.COPY.call(null) == UserAction.ActionResult.USED_STOP) {
                    usedKeys.add(Keybinds.COPY_WITH_AIR.getKey());
                }
                Selection.makeNextCopyIncludeAir = false;
            }
            if (!usedKeys.contains(Keybinds.PASTE.getKey()) && Keybinds.PASTE.isPressed(false) && UserAction.PASTE.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.PASTE.getKey());
            }
            if (!usedKeys.contains(Keybinds.CUT.getKey()) && Keybinds.CUT.isPressed(false) && UserAction.CUT.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.CUT.getKey());
            }
            if (!usedKeys.contains(Keybinds.DUPLICATE.getKey()) && Keybinds.DUPLICATE.isPressed(false) && UserAction.DUPLICATE.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.DUPLICATE.getKey());
            }
            if (!usedKeys.contains(Keybinds.UNDO.getKey()) && Keybinds.UNDO.isPressed(false) && UserAction.UNDO.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.UNDO.getKey());
            }
            if (!usedKeys.contains(Keybinds.REDO.getKey()) && Keybinds.REDO.isPressed(false) && UserAction.REDO.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.REDO.getKey());
            }
            if (!usedKeys.contains(Keybinds.SAVE_BLUEPRINT.getKey()) && Keybinds.SAVE_BLUEPRINT.isPressed(false) && UserAction.SAVE.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.SAVE_BLUEPRINT.getKey());
            }
            if (!usedKeys.contains(Keybinds.SWAP_TO_LAST_TOOL.getKey()) && Keybinds.SWAP_TO_LAST_TOOL.isPressed(false)) {
                ToolManager.swapToLastTool();
                usedKeys.add(Keybinds.SWAP_TO_LAST_TOOL.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_SELECTION.getKey()) && Keybinds.SHOW_SELECTION.isPressed(false)) {
                Selection.setShouldRenderSelection(!Selection.shouldRenderSelection());
                usedKeys.add(Keybinds.SHOW_SELECTION.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_BIOMES.getKey()) && Keybinds.SHOW_BIOMES.isPressed(false)) {
                BiomeOverlayRenderer.INSTANCE.setActive(!BiomeOverlayRenderer.INSTANCE.isActive());
                usedKeys.add(Keybinds.SHOW_BIOMES.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_ANNOTATIONS.getKey()) && Keybinds.SHOW_ANNOTATIONS.isPressed(false)) {
                Configuration.rendering.showAnnotations = !Configuration.rendering.showAnnotations;
                usedKeys.add(Keybinds.SHOW_ANNOTATIONS.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_DISPLAY_ENTITY_GIZMOS.getKey()) && Keybinds.SHOW_DISPLAY_ENTITY_GIZMOS.isPressed(false)) {
                Configuration.rendering.showDisplayEntities = !Configuration.rendering.showDisplayEntities;
                usedKeys.add(Keybinds.SHOW_DISPLAY_ENTITY_GIZMOS.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_MARKER_ENTITY_GIZMOS.getKey()) && Keybinds.SHOW_MARKER_ENTITY_GIZMOS.isPressed(false)) {
                Configuration.rendering.showMarkerEntities = !Configuration.rendering.showMarkerEntities;
                usedKeys.add(Keybinds.SHOW_MARKER_ENTITY_GIZMOS.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_COLLISION_MESH.getKey()) && Keybinds.SHOW_COLLISION_MESH.isPressed(false)) {
                Configuration.blockAttributes.showCollisionMesh = !Configuration.blockAttributes.showCollisionMesh;
                usedKeys.add(Keybinds.SHOW_COLLISION_MESH.getKey());
            }
            if (!usedKeys.contains(Keybinds.SHOW_LIGHT_BLOCKS.getKey()) && Keybinds.SHOW_LIGHT_BLOCKS.isPressed(false)) {
                Configuration.blockAttributes.showLightBlocks = !Configuration.blockAttributes.showLightBlocks;
                usedKeys.add(Keybinds.SHOW_LIGHT_BLOCKS.getKey());
                class_310.method_1551().field_1769.method_3279();
            }
            if (!usedKeys.contains(Keybinds.SHOW_STRUCTURE_VOID_BLOCKS.getKey()) && Keybinds.SHOW_STRUCTURE_VOID_BLOCKS.isPressed(false)) {
                Configuration.blockAttributes.showStructureVoidBlocks = !Configuration.blockAttributes.showStructureVoidBlocks;
                usedKeys.add(Keybinds.SHOW_STRUCTURE_VOID_BLOCKS.getKey());
                class_310.method_1551().field_1769.method_3279();
            }
            if (!usedKeys.contains(Keybinds.ROTATE_PLACEMENT.getKey()) && Keybinds.ROTATE_PLACEMENT.isPressed(false) && UserAction.ROTATE_PLACEMENT.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.ROTATE_PLACEMENT.getKey());
            }
            if (!usedKeys.contains(Keybinds.FLIP_PLACEMENT.getKey()) && Keybinds.FLIP_PLACEMENT.isPressed(false) && UserAction.FLIP_PLACEMENT.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.FLIP_PLACEMENT.getKey());
            }
            if (!usedKeys.contains(Keybinds.PASTE_AND_SELECT.getKey()) && Keybinds.PASTE_AND_SELECT.isPressed(false)) {
                Tool tool;
                if (Placement.INSTANCE.isPlacing()) {
                    Placement.INSTANCE.pastePlacement(true);
                    usedKeys.add(Keybinds.PASTE_AND_SELECT.getKey());
                } else if (ToolManager.isToolActive() && (tool = ToolManager.getCurrentTool()) instanceof ShapeTool) {
                    ShapeTool shapeTool = (ShapeTool)tool;
                    shapeTool.pasteShape(true);
                    shapeTool.reset();
                }
            }
            if (!usedKeys.contains(Keybinds.CONFIRM.getKey()) && Keybinds.CONFIRM.isPressed(false) && UserAction.ENTER.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.CONFIRM.getKey());
            }
            if (!usedKeys.contains(Keybinds.EXTRUDE_POINT.getKey()) && Keybinds.EXTRUDE_POINT.isPressed(false) && UserAction.EXTRUDE.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(Keybinds.EXTRUDE_POINT.getKey());
            }
            if (!usedKeys.contains(Keybinds.DELETE.getKey()) && Keybinds.DELETE.isPressed(false)) {
                if (UserAction.DELETE.call(null) == UserAction.ActionResult.USED_STOP) {
                    usedKeys.add(Keybinds.DELETE.getKey());
                }
            } else if (Keybinds.DELETE.getKey() == 261 && !usedKeys.contains(259) && ImGui.isKeyPressed(259, false) && UserAction.DELETE.call(null) == UserAction.ActionResult.USED_STOP) {
                usedKeys.add(259);
            }
            for (Map.Entry<Tool, Keybind> entry : ToolManager.keybindMap.entrySet()) {
                if (usedKeys.contains(entry.getValue().getKey()) || !entry.getValue().isPressed(false)) continue;
                ToolManager.setTool(entry.getKey().getClass());
                ToolManager.setToolSelected(true);
                usedKeys.add(entry.getValue().getKey());
            }
            List<View> list = ViewManager.getViews();
            for (int i = 0; i < 9 && i < list.size(); ++i) {
                Keybind keybind = Keybinds.SELECT_VIEW_KEYBINDS.get(i);
                if (!keybind.isPressed(false) || !usedKeys.add(keybind.getKey())) continue;
                focusViewNextFrame = i;
                break;
            }
        }
        ImGui.render();
        ImGuiHelper.endFrame();
        if (fireCancelNavInput) {
            EditorUI.getIO().setNavInputs(2, 1.0f);
            EditorUI.getIO().setNavInputs(1, 1.0f);
        }
        long ctx = GLFW.glfwGetCurrentContext();
        ImGui.updatePlatformWindows();
        ImGui.renderPlatformWindowsDefault();
        GLFW.glfwMakeContextCurrent((long)ctx);
        ImDrawData drawData = ImGui.getDrawData();
        if (drawData != null) {
            imguiGl3.renderDrawData(drawData);
        }
        EditorUI.transitionActiveState(true);
    }

    public static boolean isMainFrameHovered() {
        return isFrameHovered;
    }

    private static void handleScroll() {
        int wheelY = (int)Math.signum(EditorUI.getIO().getMouseWheel());
        boolean sprintMod = EditorUI.isMoveQuickDown();
        if (!sprintMod) {
            int wheelX = (int)Math.signum(EditorUI.getIO().getMouseWheelH());
            if (wheelX == 0 && wheelY == 0) {
                return;
            }
            UserAction.ScrollAmount scrollAmount = new UserAction.ScrollAmount(wheelX, wheelY);
            if (UserAction.SCROLL.call(scrollAmount) == UserAction.ActionResult.USED_STOP) {
                return;
            }
        }
        if (wheelY >= 1) {
            pendingDepthActions.add(PendingDepthAction.SCROLL_POSITIVE);
        } else if (wheelY <= -1) {
            pendingDepthActions.add(PendingDepthAction.SCROLL_NEGATIVE);
        }
    }

    private static String getPrioritizedKeybind(Set<Keybind> keybinds, boolean ctrlMod) {
        if (keybinds == null) {
            return AxiomI18n.get("axiom.editorui.no_keybind");
        }
        HashSet<Keybind> applicable = new HashSet<Keybind>(keybinds);
        applicable.removeIf(keybind -> keybind.isCtrlMod() != ctrlMod);
        if (applicable.isEmpty()) {
            return AxiomI18n.get("axiom.editorui.no_keybind");
        }
        if (applicable.contains(Keybinds.ROTATE_CAMERA)) {
            return Keybinds.ROTATE_CAMERA.getDescription();
        }
        if (applicable.contains(Keybinds.PICK_BLOCK)) {
            return Keybinds.PICK_BLOCK.getDescription();
        }
        if (applicable.contains(Keybinds.USE_TOOL) && ToolManager.isToolActive()) {
            return Keybinds.USE_TOOL.getDescription();
        }
        if (applicable.contains(Keybinds.CROSSHAIR_CAMERA)) {
            return Keybinds.CROSSHAIR_CAMERA.getDescription();
        }
        if (applicable.contains(Keybinds.ARCBALL_CAMERA)) {
            return Keybinds.ARCBALL_CAMERA.getDescription();
        }
        if (applicable.contains(Keybinds.PAN_CAMERA)) {
            return Keybinds.PAN_CAMERA.getDescription();
        }
        if (applicable.size() == 1) {
            return ((Keybind)applicable.iterator().next()).getDescription();
        }
        return AxiomI18n.get("axiom.editorui.multiple_keybinds");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean handleBasicInputs() {
        if (ImGui.isMouseClicked(0) && UserAction.LEFT_MOUSE.call(null) == UserAction.ActionResult.USED_STOP) {
            return true;
        }
        if (Keybinds.ADJUST_RADIUS.isPressed(false)) {
            if (ToolManager.isToolActive() && ToolManager.getCurrentTool().initiateAdjustment()) {
                int key = Keybinds.ADJUST_RADIUS.getKey();
                if (key != 0) {
                    imguiGlfw.setGrabbed(false, key, -1.0, -1.0);
                }
                adjustingTool = true;
                adjustingToolOffsetX = 0.0f;
                adjustingToolOffsetY = 0.0f;
                return true;
            }
        } else {
            if (Keybinds.ROTATE_CAMERA.isPressed(false)) {
                movementControls = EditorMovementControls.rotate();
                return true;
            }
            if (Keybinds.PICK_BLOCK.isPressed(false)) {
                RayCaster.RaycastResult result = Tool.raycastBlock();
                if (result != null) {
                    class_2680 blockState = class_310.method_1551().field_1687.method_8320(result.blockPos());
                    CustomBlockState customBlockState = ServerCustomBlocks.getCustomStateFor(blockState);
                    activeBlockHistory.setActive(Objects.requireNonNullElse(customBlockState, (CustomBlockState)blockState));
                    return true;
                }
            } else if (Keybinds.USE_TOOL.isPressed(false)) {
                if (UserAction.RIGHT_MOUSE.call(null) != UserAction.ActionResult.NOT_HANDLED || ToolManager.isToolActive()) {
                    return true;
                }
            } else if (Keybinds.ARCBALL_CAMERA.isPressed(false)) {
                Tool currentTool;
                Tool tool = currentTool = ToolManager.isToolActive() ? ToolManager.getCurrentTool() : null;
                if (!(currentTool instanceof RulerTool || currentTool instanceof ModifyTool || Configuration.keybind.useCenterOfScreenForArcball)) {
                    pendingDepthActions.add(PendingDepthAction.ARCBALL);
                    return true;
                }
                movementControls = EditorMovementControls.arcballFromRaycast();
                if (movementControls != EditorMovementControls.none()) {
                    int key = Keybinds.ARCBALL_CAMERA.getKey();
                    if (key != 0) {
                        imguiGlfw.setGrabbed(false, key, (float)frameX + (float)frameWidth / 2.0f, (float)frameY + (float)frameHeight / 2.0f);
                    }
                    return true;
                }
            } else if (Keybinds.PAN_CAMERA.isPressed(false)) {
                pendingDepthActions.add(PendingDepthAction.PAN);
                return true;
            }
        }
        if (!Keybinds.CROSSHAIR_CAMERA.isPressed(false)) {
            return false;
        }
        int key = Keybinds.CROSSHAIR_CAMERA.getKey();
        if (key != 0) {
            imguiGlfw.setGrabbed(true, key, (float)frameX + (float)frameWidth / 2.0f, (float)frameY + (float)frameHeight / 2.0f);
        }
        return true;
    }

    public static BlockList getBlockList() {
        return blockList;
    }

    public static boolean consumeNavClose() {
        boolean navClose = EditorUI.navClose;
        EditorUI.navClose = false;
        return navClose;
    }

    public static boolean isMoveQuickDown() {
        if (Keybinds.useVanillaMovement) {
            if (EditorUI.isActive()) {
                return imGuiIO.getKeysDown(class_310.method_1551().field_1690.field_1867.field_1655.method_1444());
            }
            return class_310.method_1551().field_1690.field_1867.method_1434();
        }
        return Keybinds.MOVE_QUICK.isDownIgnoreMods();
    }

    public static boolean isCtrlOrCmdDown() {
        return class_310.field_1703 ? EditorUI.getIO().getKeySuper() : EditorUI.getIO().getKeyCtrl();
    }
}

