/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2202;
import net.minecraft.class_2231;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2362;
import net.minecraft.class_2366;
import net.minecraft.class_2397;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3713;
import net.minecraft.class_3718;
import net.minecraft.class_4719;
import net.minecraft.class_4771;
import net.minecraft.class_4774;
import net.minecraft.class_4849;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;

public class MaterialBlockTagGenerator {
    public static final Map<class_2248, String> blockToMaterialMap = Map.ofEntries(Map.entry(class_2246.field_10340, "stone"), Map.entry(class_2246.field_10277, "stone"), Map.entry(class_2246.field_10360, "stone"), Map.entry(class_2246.field_10445, "cobblestone"), Map.entry(class_2246.field_9989, "cobblestone"), Map.entry(class_2246.field_10492, "cobblestone"), Map.entry(class_2246.field_28888, "deepslate"), Map.entry(class_2246.field_29224, "deepslate"), Map.entry(class_2246.field_28904, "deepslate"), Map.entry(class_2246.field_38420, "deepslate"), Map.entry(class_2246.field_29031, "deepslate"), Map.entry(class_2246.field_28892, "deepslate"), Map.entry(class_2246.field_28896, "deepslate"), Map.entry(class_2246.field_29223, "deepslate"), Map.entry(class_2246.field_28900, "deepslate"), Map.entry(class_2246.field_29222, "deepslate"), Map.entry(class_2246.field_10104, "bricks"), Map.entry(class_2246.field_10056, "stone_brick"), Map.entry(class_2246.field_10065, "stone_brick"), Map.entry(class_2246.field_10416, "stone_brick"), Map.entry(class_2246.field_10552, "stone_brick"), Map.entry(class_2246.field_10387, "stone_brick"), Map.entry(class_2246.field_10480, "stone_brick"), Map.entry(class_2246.field_10100, "stone_brick"), Map.entry(class_2246.field_10176, "stone_brick"), Map.entry(class_2246.field_37557, "mud_brick"), Map.entry(class_2246.field_10266, "nether_brick"), Map.entry(class_2246.field_23866, "nether_brick"), Map.entry(class_2246.field_23867, "nether_brick"), Map.entry(class_2246.field_9986, "nether_brick"), Map.entry(class_2246.field_9979, "sandstone"), Map.entry(class_2246.field_10467, "sandstone"), Map.entry(class_2246.field_10292, "sandstone"), Map.entry(class_2246.field_10361, "sandstone"), Map.entry(class_2246.field_10344, "sandstone"), Map.entry(class_2246.field_10483, "sandstone"), Map.entry(class_2246.field_10117, "sandstone"), Map.entry(class_2246.field_10518, "sandstone"), Map.entry(class_2246.field_10161, "oak"), Map.entry(class_2246.field_10298, "oak"), Map.entry(class_2246.field_9975, "spruce"), Map.entry(class_2246.field_10148, "birch"), Map.entry(class_2246.field_10218, "acacia"), Map.entry(class_2246.field_10211, "bamboo"), Map.entry(class_2246.field_40294, "bamboo"), Map.entry(class_2246.field_41072, "bamboo"), Map.entry(class_2246.field_40295, "bamboo"), Map.entry(class_2246.field_41073, "bamboo"), Map.entry(class_2246.field_42751, "cherry"), Map.entry(class_2246.field_22126, "crimson"), Map.entry(class_2246.field_22118, "crimson"), Map.entry(class_2246.field_22119, "crimson"), Map.entry(class_2246.field_22505, "crimson"), Map.entry(class_2246.field_22506, "crimson"), Map.entry(class_2246.field_22127, "warped"), Map.entry(class_2246.field_22111, "warped"), Map.entry(class_2246.field_22112, "warped"), Map.entry(class_2246.field_22503, "warped"), Map.entry(class_2246.field_22504, "warped"), Map.entry(class_2246.field_10075, "dark_oak"), Map.entry(class_2246.field_10334, "jungle"), Map.entry(class_2246.field_37577, "mangrove"), Map.entry(class_2246.field_37546, "mangrove"), Map.entry(class_2246.field_37547, "mangrove"), Map.entry(class_2246.field_10153, "quartz"), Map.entry(class_2246.field_9978, "quartz"), Map.entry(class_2246.field_10044, "quartz"), Map.entry(class_2246.field_10437, "quartz"), Map.entry(class_2246.field_23868, "quartz"), Map.entry(class_2246.field_10135, "prismarine"), Map.entry(class_2246.field_10006, "prismarine"), Map.entry(class_2246.field_10297, "prismarine"), Map.entry(class_2246.field_10286, "purpur"), Map.entry(class_2246.field_10505, "purpur"), Map.entry(class_2246.field_10474, "granite"), Map.entry(class_2246.field_10289, "granite"), Map.entry(class_2246.field_10508, "diorite"), Map.entry(class_2246.field_10346, "diorite"), Map.entry(class_2246.field_10115, "andesite"), Map.entry(class_2246.field_10093, "andesite"), Map.entry(class_2246.field_23869, "blackstone"), Map.entry(class_2246.field_23880, "blackstone"), Map.entry(class_2246.field_23873, "blackstone"), Map.entry(class_2246.field_23876, "blackstone"), Map.entry(class_2246.field_23874, "blackstone"), Map.entry(class_2246.field_23875, "blackstone"), Map.entry(class_2246.field_10471, "end_stone"), Map.entry(class_2246.field_10462, "end_stone"), Map.entry(class_2246.field_27119, "copper"), Map.entry(class_2246.field_33509, "copper"), Map.entry(class_2246.field_27124, "copper"), Map.entry(class_2246.field_27116, "copper"), Map.entry(class_2246.field_27121, "copper"), Map.entry(class_2246.field_27117, "copper"), Map.entry(class_2246.field_27122, "copper"), Map.entry(class_2246.field_27118, "copper"), Map.entry(class_2246.field_27123, "copper"), Map.entry(class_2246.field_27133, "copper"), Map.entry(class_2246.field_27134, "copper"), Map.entry(class_2246.field_27135, "copper"), Map.entry(class_2246.field_33407, "copper"), Map.entry(class_2246.field_27138, "copper"), Map.entry(class_2246.field_33408, "copper"), Map.entry(class_2246.field_27136, "copper"), Map.entry(class_2246.field_27137, "copper"), Map.entry(class_2246.field_47054, "copper"), Map.entry(class_2246.field_47055, "copper"), Map.entry(class_2246.field_47056, "copper"), Map.entry(class_2246.field_47057, "copper"), Map.entry(class_2246.field_47058, "copper"), Map.entry(class_2246.field_47059, "copper"), Map.entry(class_2246.field_47060, "copper"), Map.entry(class_2246.field_47061, "copper"), Map.entry(class_2246.field_47072, "copper"), Map.entry(class_2246.field_47073, "copper"), Map.entry(class_2246.field_47074, "copper"), Map.entry(class_2246.field_47075, "copper"), Map.entry(class_2246.field_47076, "copper"), Map.entry(class_2246.field_47077, "copper"), Map.entry(class_2246.field_47078, "copper"), Map.entry(class_2246.field_47079, "copper"), Map.entry(class_2246.field_47064, "copper"), Map.entry(class_2246.field_47065, "copper"), Map.entry(class_2246.field_47066, "copper"), Map.entry(class_2246.field_47067, "copper"), Map.entry(class_2246.field_47068, "copper"), Map.entry(class_2246.field_47069, "copper"), Map.entry(class_2246.field_47070, "copper"), Map.entry(class_2246.field_47071, "copper"), Map.entry(class_2246.field_10085, "iron"), Map.entry(class_2246.field_33508, "iron"), Map.entry(class_2246.field_10576, "iron"), Map.entry(class_2246.field_10205, "gold"), Map.entry(class_2246.field_33510, "gold"), Map.entry(class_2246.field_10415, "terracotta"), Map.entry(class_2246.field_27165, "tuff"), Map.entry(class_2246.field_47034, "tuff"), Map.entry(class_2246.field_47030, "tuff"), Map.entry(class_2246.field_47035, "tuff"), Map.entry(class_2246.field_47039, "tuff"));
    public static final Map<class_8177, String> setTypeToMaterialMap = Map.ofEntries(Map.entry(class_8177.field_42819, "iron"), Map.entry(class_8177.field_47100, "copper"), Map.entry(class_8177.field_42820, "gold"), Map.entry(class_8177.field_42821, "stone"), Map.entry(class_8177.field_42822, "blackstone"), Map.entry(class_8177.field_42823, "oak"), Map.entry(class_8177.field_42824, "spruce"), Map.entry(class_8177.field_42825, "birch"), Map.entry(class_8177.field_42826, "acacia"), Map.entry(class_8177.field_42827, "cherry"), Map.entry(class_8177.field_42828, "jungle"), Map.entry(class_8177.field_42829, "dark_oak"), Map.entry(class_8177.field_42830, "crimson"), Map.entry(class_8177.field_42831, "warped"), Map.entry(class_8177.field_42832, "mangrove"), Map.entry(class_8177.field_42833, "bamboo"));
    public static final Map<class_4719, String> woodTypeToMaterialMap = Map.ofEntries(Map.entry(class_4719.field_21676, "oak"), Map.entry(class_4719.field_21677, "spruce"), Map.entry(class_4719.field_21678, "birch"), Map.entry(class_4719.field_21679, "acacia"), Map.entry(class_4719.field_42837, "cherry"), Map.entry(class_4719.field_21680, "jungle"), Map.entry(class_4719.field_21681, "dark_oak"), Map.entry(class_4719.field_22183, "crimson"), Map.entry(class_4719.field_22184, "warped"), Map.entry(class_4719.field_37657, "mangrove"), Map.entry(class_4719.field_40350, "bamboo"));
    private static final Map<String, LinkedHashSet<class_2248>> materialMap = new HashMap<String, LinkedHashSet<class_2248>>();

    public static void addTags(class_7225.class_7874 arg, Function<class_6862<class_2248>, FabricTagProvider.FabricTagBuilder> builderFunction) {
        class_2960 location;
        for (class_2248 class_22482 : class_7923.field_41175) {
            String material;
            location = ((class_5321)class_22482.method_40142().method_40230().get()).method_29177();
            if (class_22482 instanceof class_2323) {
                class_2323 doorBlock = (class_2323)class_22482;
                material = setTypeToMaterialMap.get(doorBlock.field_42757);
                MaterialBlockTagGenerator.forMaterial(material).add(class_22482);
                continue;
            }
            if (class_22482 instanceof class_2533) {
                class_2533 trapDoorBlock = (class_2533)class_22482;
                material = setTypeToMaterialMap.get(trapDoorBlock.field_42779);
                MaterialBlockTagGenerator.forMaterial(material).add(class_22482);
                continue;
            }
            if (class_22482 instanceof class_2231) {
                class_2231 pressurePlateBlock = (class_2231)class_22482;
                material = setTypeToMaterialMap.get(pressurePlateBlock.field_42726);
                MaterialBlockTagGenerator.forMaterial(material).add(class_22482);
                continue;
            }
            if (class_22482 instanceof class_2510) {
                class_2510 stairBlock = (class_2510)class_22482;
                material = blockToMaterialMap.get(stairBlock.field_11579);
                if (material == null) {
                    throw new RuntimeException("Missing material for: " + String.valueOf(stairBlock.field_11579));
                }
                LinkedHashSet<class_2248> set = MaterialBlockTagGenerator.forMaterial(material);
                set.add(class_22482);
                String ns = location.method_12836();
                String path = location.method_12832();
                class_7923.field_41175.method_17966(class_2960.method_60655((String)ns, (String)path.replace("_stairs", "_slab"))).ifPresent(set::add);
                class_7923.field_41175.method_17966(class_2960.method_60655((String)ns, (String)path.replace("_stairs", "_wall"))).ifPresent(set::add);
                class_7923.field_41175.method_17966(class_2960.method_60655((String)ns, (String)path.replace("_stairs", "_fence"))).ifPresent(set::add);
                continue;
            }
            if (blockToMaterialMap.containsKey(class_22482)) {
                MaterialBlockTagGenerator.forMaterial(blockToMaterialMap.get(class_22482)).add(class_22482);
                continue;
            }
            if (!(class_22482 instanceof class_2366) && !location.method_12832().endsWith("_terracotta")) continue;
            MaterialBlockTagGenerator.forMaterial("terracotta").add(class_22482);
        }
        for (Map.Entry<class_2248, String> entry : blockToMaterialMap.entrySet()) {
            location = ((class_5321)entry.getKey().method_40142().method_40230().get()).method_29177();
            String ns = location.method_12836();
            String path = location.method_12832();
            class_7923.field_41175.method_17966(class_2960.method_60655((String)ns, (String)((String)path + "_slab"))).ifPresent(block -> MaterialBlockTagGenerator.forMaterial((String)entry.getValue()).add((class_2248)block));
            class_7923.field_41175.method_17966(class_2960.method_60655((String)ns, (String)((String)path + "_wall"))).ifPresent(block -> MaterialBlockTagGenerator.forMaterial((String)entry.getValue()).add((class_2248)block));
        }
        class_8177.method_49232().forEach(type2 -> {
            String material = setTypeToMaterialMap.get(type2);
            String name = type2.comp_1289();
            ArrayList<Optional> blocks = new ArrayList<Optional>();
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_stairs"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_slab"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_fence"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_fence_gate"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_door"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_trapdoor"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_pressure_plate"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_button"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_sign"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_wall_sign"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_hanging_sign"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_wall_hanging_sign"))));
            LinkedHashSet<class_2248> builder = MaterialBlockTagGenerator.forMaterial(material);
            blocks.forEach(optional -> optional.ifPresent(builder::add));
        });
        class_4719.method_24026().forEach(type2 -> {
            String material = woodTypeToMaterialMap.get(type2);
            String name = type2.comp_1299();
            ArrayList<Optional> blocks = new ArrayList<Optional>();
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_log"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_wood"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)("stripped_" + name + "_log"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)("stripped_" + name + "_wood"))));
            blocks.add(class_7923.field_41175.method_17966(class_2960.method_60655((String)"minecraft", (String)(name + "_planks"))));
            LinkedHashSet<class_2248> builder = MaterialBlockTagGenerator.forMaterial(material);
            blocks.forEach(optional -> optional.ifPresent(builder::add));
        });
        for (Map.Entry<Object, Object> entry : materialMap.entrySet()) {
            Object block322;
            boolean containsStairVariant = false;
            boolean containsSlabVariant = false;
            for (Object block322 : (LinkedHashSet)entry.getValue()) {
                containsStairVariant |= block322 instanceof class_2510;
                containsSlabVariant |= block322 instanceof class_2482;
            }
            if (!(!containsStairVariant && !containsSlabVariant || containsStairVariant && containsSlabVariant)) {
                throw new RuntimeException((String)entry.getKey() + " contained one variant, but not the other\ncontainsStairVariant = " + containsStairVariant + "\ncontainsSlabVariant = " + containsSlabVariant + "\n");
            }
            FabricTagProvider.FabricTagBuilder builder = builderFunction.apply((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"material", (String)((String)entry.getKey()))));
            block322 = ((LinkedHashSet)entry.getValue()).iterator();
            while (block322.hasNext()) {
                class_2248 block4 = (class_2248)block322.next();
                builder.add((Object)block4);
            }
        }
        FabricTagProvider.FabricTagBuilder builder = builderFunction.apply((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"material", (String)"wood")));
        class_4719.method_24026().forEach(type2 -> {
            String material = woodTypeToMaterialMap.get(type2);
            builder.addTag(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"material", (String)material)));
        });
        for (class_2248 class_22483 : class_7923.field_41175) {
            String path;
            boolean inMaterial = false;
            for (LinkedHashSet<class_2248> set : materialMap.values()) {
                if (!set.contains(class_22483)) continue;
                if (inMaterial) {
                    throw new RuntimeException(String.valueOf(class_22483) + " is in two materials at once!");
                }
                inMaterial = true;
            }
            if (inMaterial) continue;
            if (class_22483 instanceof class_2510 || class_22483 instanceof class_2482 || class_22483 instanceof class_2544) {
                throw new RuntimeException(String.valueOf(class_22483) + " is missing a material!");
            }
            if (class_22483 instanceof class_2473 || class_22483 instanceof class_2202 || class_22483 instanceof class_2362 || class_22483 instanceof class_2397 || class_22483 instanceof class_3713 || class_22483 instanceof class_3718 || class_22483 instanceof class_4849 || class_22483 instanceof class_4771 || class_22483 instanceof class_4774 || (path = ((class_5321)class_22483.method_40142().method_40230().get()).method_29177().method_12832()).endsWith("_ore") || path.equals("warped_wart_block") || path.equals("crimson_wart_block") || path.equals("lodestone")) continue;
            for (String material : blockToMaterialMap.values()) {
                if (material.equals("stone") && path.contains("redstone") || material.equals("stone") && path.contains("glowstone") || material.equals("stone") && path.contains("sandstone") || material.equals("stone") && path.contains("dripstone") || !path.contains(material)) continue;
                throw new RuntimeException(String.valueOf(class_22483) + " contains '" + material + "'. Should it be part of the '" + material + "' material?");
            }
        }
    }

    private static LinkedHashSet<class_2248> forMaterial(String material) {
        if (!blockToMaterialMap.values().contains(material)) {
            throw new RuntimeException("Unknown material: " + material);
        }
        return materialMap.computeIfAbsent(material, type2 -> new LinkedHashSet());
    }
}

