/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.harium.storage.kdtree.KDTree;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.OkLabColourUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2366;
import net.minecraft.class_2372;
import net.minecraft.class_2384;
import net.minecraft.class_2397;
import net.minecraft.class_2426;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7923;

public class BlockColourMap {
    public static int FLAG_SOLID = 1;
    public static int FLAG_OPAQUE = 2;
    public static int FLAG_FULL_CUBE = 4;
    public static int FLAG_SAME_TEXTURE = 8;
    public static int FLAG_NO_ORES = 16;
    public static int FLAG_NO_GLAZED_TERRACOTTA = 32;
    public static int FLAG_NO_TILE_ENTITIES = 64;
    private static final KDTree<class_2680> tree = new KDTree(3);
    private static final Map<CustomBlock, double[]> colourMap = new HashMap<CustomBlock, double[]>();
    private static final Set<CustomBlock> sameTextureSet = new HashSet<CustomBlock>();
    private static boolean coloursDirty = true;
    private static int lastTreeFlags = -1;
    private static final Set<String> ERRORED_MODS = new HashSet<String>();
    private static final class_2350[] MODEL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033, null};
    private static final ThreadLocal<double[]> bufferLocal = new ThreadLocal();

    private static void recalculateColours() {
        class_2680 defaultState;
        if (!coloursDirty) {
            return;
        }
        coloursDirty = false;
        colourMap.clear();
        sameTextureSet.clear();
        LinkedHashSet<class_2680> blockStates = new LinkedHashSet<class_2680>();
        for (CustomBlock block : ServerCustomBlocks.customBlockMap.values()) {
            defaultState = block.axiom$defaultCustomState().getVanillaState();
            blockStates.add(defaultState);
        }
        for (CustomBlock block : class_7923.field_41175) {
            defaultState = block.method_9564();
            blockStates.add(defaultState);
        }
        for (class_2680 blockState : blockStates) {
            BlockColourResult result = BlockColourMap.calculateLAB(blockState);
            if (result == null) continue;
            CustomBlock customBlock = ServerCustomBlocks.getCustomOrVanillaStateFor(blockState).getCustomBlock();
            double[] lab = new double[]{result.l, result.a, result.b};
            colourMap.put(customBlock, lab);
            if (result.numTextures > 1) continue;
            sameTextureSet.add(customBlock);
        }
    }

    private static void recalculateTree(int flags) {
        BlockColourMap.recalculateColours();
        if (lastTreeFlags == flags) {
            return;
        }
        lastTreeFlags = flags;
        tree.clear();
        for (Map.Entry<CustomBlock, double[]> entry : colourMap.entrySet()) {
            CustomBlock block = entry.getKey();
            double[] lab = entry.getValue();
            class_2680 defaultState = block.axiom$defaultCustomState().getVanillaState();
            if (defaultState.method_26217() != class_2464.field_11458 || BlockColourMap.isHardIgnore(defaultState.method_26204()) || (flags & FLAG_SOLID) != 0 && !BlockColourMap.isSolid(defaultState) || (flags & FLAG_OPAQUE) != 0 && !BlockColourMap.isOpaque(defaultState) || (flags & FLAG_FULL_CUBE) != 0 && !BlockColourMap.isFullCube(defaultState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) || (flags & FLAG_SAME_TEXTURE) != 0 && !sameTextureSet.contains(block) || (flags & FLAG_NO_ORES) != 0 && BlockColourMap.isOre(defaultState) || (flags & FLAG_NO_GLAZED_TERRACOTTA) != 0 && BlockColourMap.isGlazedTerracotta(defaultState) || (flags & FLAG_NO_TILE_ENTITIES) != 0 && BlockColourMap.isTileEntity(defaultState)) continue;
            tree.edit(lab, old -> {
                if (old != null) {
                    String oldName = old.method_26204().method_40142().method_40237().method_29177().method_12832();
                    String newName = defaultState.method_26204().method_40142().method_40237().method_29177().method_12832();
                    if (oldName.length() <= newName.length()) {
                        return old;
                    }
                    return defaultState;
                }
                return defaultState;
            });
        }
    }

    public static void invalidateCache() {
        colourMap.clear();
        tree.clear();
        coloursDirty = true;
        lastTreeFlags = -1;
    }

    private static BlockColourResult calculateLAB(class_2680 blockState) {
        class_776 renderManager = class_310.method_1551().method_1541();
        class_5819 rand = class_5819.method_43047();
        double totalL = 0.0;
        double totalA = 0.0;
        double totalB = 0.0;
        double totalAlpha = 0.0;
        double[] lab = new double[3];
        HashSet<class_1058> sprites = new HashSet<class_1058>();
        class_1087 bakedModel = renderManager.method_3349(blockState);
        for (class_2350 direction : MODEL_DIRECTIONS) {
            for (class_777 quad : bakedModel.method_4707(blockState, direction, rand)) {
                class_1058 sprite;
                if (quad == null || (sprite = quad.method_35788()) == null) continue;
                float redMult = 1.0f;
                float greenMult = 1.0f;
                float blueMult = 1.0f;
                if (quad.method_3360()) {
                    try {
                        int tintIndex = quad.method_3359();
                        int rgb = class_310.method_1551().method_1505().method_1697(blockState, null, null, tintIndex);
                        redMult = (float)(rgb >> 16 & 0xFF) / 255.0f;
                        greenMult = (float)(rgb >> 8 & 0xFF) / 255.0f;
                        blueMult = (float)(rgb & 0xFF) / 255.0f;
                    }
                    catch (Exception e) {
                        class_2960 location = blockState.method_26204().method_40142().method_40237().method_29177();
                        String mod = location.method_12836();
                        if (ERRORED_MODS.add(mod)) {
                            Axiom.LOGGER.warn("Mod {} threw an exception when asked for the color of {}. This is usually because the mod doesn't correctly handle null values for BlockAndTintGetter/BlockPos. The block has been excluded from the colour-related features of Axiom", mod, location, e);
                        }
                        return null;
                    }
                }
                sprites.add(sprite);
                class_7764 spriteContents = sprite.method_45851();
                class_1011 image = spriteContents.field_40540[0];
                int width = spriteContents.method_45807();
                int height = spriteContents.method_45815();
                for (int u = 0; u < width; ++u) {
                    for (int v = 0; v < height; ++v) {
                        int argb = ColourUtils.abgrToArgb(image.method_4315(u, v));
                        int alpha = argb >> 24 & 0xFF;
                        int red = (int)((float)(argb >> 16 & 0xFF) * redMult);
                        int green = (int)((float)(argb >> 8 & 0xFF) * greenMult);
                        int blue = (int)((float)(argb & 0xFF) * blueMult);
                        OkLabColourUtils.rgb2lab(red, green, blue, lab);
                        float scale = (float)alpha / 255.0f;
                        totalL += lab[0] * (double)scale;
                        totalA += lab[1] * (double)scale;
                        totalB += lab[2] * (double)scale;
                        totalAlpha += (double)scale;
                    }
                }
            }
        }
        if (totalAlpha < 1.0) {
            return null;
        }
        double finalL = totalL / totalAlpha;
        double finalA = totalA / totalAlpha;
        double finalB = totalB / totalAlpha;
        return new BlockColourResult(finalL, finalA, finalB, sprites.size());
    }

    private static boolean isSolid(class_2680 blockState) {
        return blockState.method_51366();
    }

    private static boolean isOpaque(class_2680 blockState) {
        return (class_4696.method_23679((class_2680)blockState) == class_1921.method_23577() || blockState.method_26204() instanceof class_2372) && !(blockState.method_26204() instanceof class_2397);
    }

    private static boolean isFullCube(class_265 shape) {
        return shape == class_259.method_1077();
    }

    private static boolean isOre(class_2680 blockState) {
        return blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_ore");
    }

    private static boolean isGlazedTerracotta(class_2680 blockState) {
        return blockState.method_26204() instanceof class_2366 || blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_glazed_terracotta");
    }

    private static boolean isTileEntity(class_2680 blockState) {
        return blockState.method_31709() || blockState.method_26204() instanceof class_2426;
    }

    public static boolean isHardIgnore(class_2248 block) {
        return block instanceof class_2384 || block == class_2246.field_22113;
    }

    public static boolean isFullSolidOpaque(class_2680 blockState) {
        return blockState.method_26217() == class_2464.field_11458 && BlockColourMap.isFullCube(blockState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) && BlockColourMap.isSolid(blockState) && BlockColourMap.isOpaque(blockState);
    }

    public static double[] getLab(class_2248 block) {
        BlockColourMap.recalculateColours();
        return colourMap.get((CustomBlock)block);
    }

    public static double[] getLab(CustomBlock block) {
        BlockColourMap.recalculateColours();
        return colourMap.get(block);
    }

    public static class_2680 getNearestLab(double l, double a, double b, int flags) {
        BlockColourMap.recalculateTree(flags);
        double[] buffer = bufferLocal.get();
        if (buffer == null) {
            buffer = new double[3];
            bufferLocal.set(buffer);
        }
        buffer[0] = l;
        buffer[1] = a;
        buffer[2] = b;
        return tree.nearest(buffer);
    }

    public static List<class_2680> getNearestLabN(double l, double a, double b, int flags, int count) {
        BlockColourMap.recalculateTree(flags);
        double[] buffer = bufferLocal.get();
        if (buffer == null) {
            buffer = new double[3];
            bufferLocal.set(buffer);
        }
        buffer[0] = l;
        buffer[1] = a;
        buffer[2] = b;
        return tree.nearest(buffer, count);
    }

    private record BlockColourResult(double l, double a, double b, int numTextures) {
    }
}

