/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.capabilities.Capability;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.stamp.StampTool;
import com.moulberry.axiom.utils.Box;
import java.util.List;

public class Restrictions {
    public static final int ALLOW_BULLDOZER = 1;
    public static final int ALLOW_REPLACE_MODE = 2;
    public static final int ALLOW_FORCE_PLACE = 4;
    public static final int ALLOW_NO_UPDATES = 8;
    public static final int ALLOW_TINKER = 16;
    public static final int ALLOW_INFINITE_REACH = 32;
    public static final int ALLOW_FAST_PLACE = 64;
    public static final int ALLOW_ANGEL_PLACEMENT = 128;
    public static final int ALLOW_NO_CLIP = 256;
    public static final int ALLOW_ALL = -1;
    public static boolean canImportBlocks = true;
    public static boolean canUseEditor = true;
    public static boolean canEditDisplayEntities = true;
    public static boolean canCreateAnnotations = true;
    public static int allowedCapabilities = -1;
    public static int infiniteReachLimit = -1;
    public static RateLimiter rateLimiter = null;
    public static List<Box> bounds = List.of();
    public static Box globalBounds = null;

    public static void update(AxiomClientboundRestrictions restrictions) {
        if (canImportBlocks && !restrictions.canImportBlocks) {
            Clipboard.INSTANCE.clearClipboard();
            Placement.INSTANCE.stopPlacement();
            for (Tool tool : ToolManager.getTools()) {
                if (!(tool instanceof StampTool)) continue;
                StampTool stampTool = (StampTool)tool;
                stampTool.clearBlueprints();
            }
        }
        if (EditorUI.isActive() && !restrictions.canUseEditor) {
            EditorUI.toggleEnabled();
        }
        if (DisplayEntityManipulator.hasActiveGizmo() && !restrictions.canEditDisplayEntities) {
            DisplayEntityManipulator.disableActive();
        }
        canImportBlocks = restrictions.canImportBlocks;
        canUseEditor = restrictions.canUseEditor;
        canEditDisplayEntities = restrictions.canEditDisplayEntities;
        canCreateAnnotations = restrictions.canCreateAnnotations;
        allowedCapabilities = restrictions.allowedCapabilities;
        infiniteReachLimit = restrictions.infiniteReachLimit >= 0 && restrictions.infiniteReachLimit < 8 ? 8 : restrictions.infiniteReachLimit;
        if ((allowedCapabilities & 1) == 0) {
            Capability.BULLDOZER.setEnabled(false);
        }
        if ((allowedCapabilities & 2) == 0) {
            Capability.REPLACE_MODE.setEnabled(false);
        }
        if ((allowedCapabilities & 4) == 0) {
            Capability.FORCE_PLACE.setEnabled(false);
        }
        if ((allowedCapabilities & 8) == 0) {
            Capability.NO_UPDATES.setEnabled(false);
        }
        if ((allowedCapabilities & 0x10) == 0) {
            Capability.TINKER.setEnabled(false);
        }
        if ((allowedCapabilities & 0x20) == 0) {
            Capability.INFINITE_REACH.setEnabled(false);
        }
        if ((allowedCapabilities & 0x40) == 0) {
            Capability.FAST_PLACE.setEnabled(false);
        }
        if ((allowedCapabilities & 0x80) == 0) {
            Capability.ANGEL_PLACEMENT.setEnabled(false);
        }
        if ((allowedCapabilities & 0x100) == 0) {
            Capability.NO_CLIP.setEnabled(false);
        }
        if (restrictions.maxSectionsPerSecond <= 0) {
            rateLimiter = null;
        } else if (rateLimiter != null) {
            rateLimiter.setRate((double)restrictions.maxSectionsPerSecond);
        } else {
            rateLimiter = RateLimiter.create((double)restrictions.maxSectionsPerSecond);
        }
        bounds = restrictions.bounds;
        globalBounds = restrictions.globalBounds;
    }

    public static SelectionBuffer constrainSelection(SelectionBuffer selectionBuffer) {
        if (!bounds.isEmpty()) {
            if (bounds.size() == 1) {
                Box bounds = Restrictions.bounds.get(0);
                selectionBuffer = selectionBuffer.intersectAABB(bounds.pos1(), bounds.pos2(), false);
            } else {
                ChunkedBooleanRegion chunkedBooleanRegion = new ChunkedBooleanRegion();
                selectionBuffer.forEach((x, y, z) -> {
                    for (Box bound : bounds) {
                        if (bound.pos1().method_10263() > x || bound.pos2().method_10263() < x || bound.pos1().method_10264() > y || bound.pos2().method_10264() < y || bound.pos1().method_10260() > z || bound.pos2().method_10260() < z) continue;
                        chunkedBooleanRegion.add(x, y, z);
                    }
                });
                selectionBuffer.close();
                selectionBuffer = new SelectionBuffer.Set(chunkedBooleanRegion);
            }
            return selectionBuffer.optimize();
        }
        return selectionBuffer;
    }

    public static void reset() {
        canImportBlocks = true;
        canUseEditor = true;
        canEditDisplayEntities = true;
        canCreateAnnotations = true;
        allowedCapabilities = -1;
        rateLimiter = null;
        bounds = List.of();
        globalBounds = null;
    }
}

