/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.utils.StringUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3551;
import net.minecraft.class_636;
import net.minecraft.class_7225;
import net.minecraft.class_746;

public class HotbarManager {
    private static int activeHotbarIndex = 0;
    private static Int2ObjectMap<class_1799> items = new Int2ObjectOpenHashMap();
    private static String location = null;
    private static String altLocation = null;
    private static int saveTimer = 0;

    public static void clearPage() {
        int page = activeHotbarIndex / 9;
        int itemIndexOffset = page * 81;
        for (int i = 0; i < 81; ++i) {
            items.remove(i + itemIndexOffset);
        }
        activeHotbarIndex = page * 9;
        if (saveTimer <= 0) {
            saveTimer = 200;
        }
    }

    public static void clearAll() {
        activeHotbarIndex = 0;
        items.clear();
        saveTimer = 0;
    }

    public static void tickSaving() {
        class_746 player = class_310.method_1551().field_1724;
        if (location == null || player == null) {
            saveTimer = 0;
            return;
        }
        if (saveTimer > 0 && --saveTimer == 0) {
            HotbarManager.trySave(player, true);
        }
    }

    public static void trySave(class_746 player, boolean force) {
        if (!force && saveTimer <= 0) {
            return;
        }
        saveTimer = 0;
        if (location == null) {
            return;
        }
        try {
            Path altPath;
            Path hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(location);
            Path path = altPath = altLocation == null ? null : Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(altLocation);
            if (altPath != null && !Files.exists(hotbarDataPath, new LinkOption[0]) && Files.exists(altPath, new LinkOption[0])) {
                hotbarDataPath = altPath;
            }
            if (activeHotbarIndex == 0 && items.isEmpty()) {
                Files.deleteIfExists(hotbarDataPath);
                if (altPath != null) {
                    Files.deleteIfExists(altPath);
                }
                return;
            }
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10569("ActiveHotbarIndex", activeHotbarIndex);
            compoundTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
            class_2487 itemsTag = new class_2487();
            for (Int2ObjectMap.Entry entry : items.int2ObjectEntrySet()) {
                class_1799 itemStack = (class_1799)entry.getValue();
                if (itemStack.method_7960()) continue;
                itemsTag.method_10566("" + entry.getIntKey(), itemStack.method_57375((class_7225.class_7874)player.method_56673()));
            }
            compoundTag.method_10566("Items", (class_2520)itemsTag);
            Files.createDirectories(hotbarDataPath.getParent(), new FileAttribute[0]);
            class_2507.method_30614((class_2487)compoundTag, (Path)hotbarDataPath);
            if (altPath != null && altPath != hotbarDataPath && !Files.exists(altPath, new LinkOption[0])) {
                try {
                    Files.createLink(altPath, hotbarDataPath);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Error saving hotbars", e);
        }
    }

    public static void updateLocation() {
        block21: {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (location != null) {
                HotbarManager.trySave(player, false);
            }
            String oldLocation = location;
            location = null;
            altLocation = null;
            if (class_310.method_1551().method_1496()) {
                location = class_310.method_1551().method_1576().field_23784.method_27005();
            } else {
                SocketAddress address = class_310.method_1551().method_1562().method_48296().method_10755();
                if (address instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    location = inetSocketAddress.getAddress().getHostAddress();
                } else {
                    location = address.toString();
                }
                if (ClientEvents.lastServerAddress != null) {
                    altLocation = ClientEvents.lastServerAddress.method_2952();
                    altLocation = StringUtils.sanitizePath(altLocation);
                }
            }
            location = StringUtils.sanitizePath(location);
            if (!Objects.equals(oldLocation, location)) {
                HotbarManager.clearAll();
                if (location != null) {
                    Path hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(location);
                    if (!Files.exists(hotbarDataPath, new LinkOption[0])) {
                        if (altLocation == null) {
                            return;
                        }
                        hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(altLocation);
                        if (!Files.exists(hotbarDataPath, new LinkOption[0])) {
                            return;
                        }
                    }
                    try {
                        class_2487 compoundTag = class_2507.method_30613((Path)hotbarDataPath, (class_2505)class_2505.method_53898());
                        int currentDataVersion = class_155.method_16673().method_37912().method_38494();
                        activeHotbarIndex = VersionUtilsNbt.helperCompoundTagGetIntOr(compoundTag, "ActiveHotbarIndex", 0);
                        int dataVersion = VersionUtilsNbt.helperCompoundTagGetIntOr(compoundTag, "DataVersion", currentDataVersion);
                        if (dataVersion > currentDataVersion) break block21;
                        class_2487 itemsTag = compoundTag.method_10562("Items");
                        for (String key : itemsTag.method_10541()) {
                            Optional<class_1799> itemStackOptional;
                            int keyInt = -1;
                            try {
                                keyInt = Integer.parseInt(key);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (keyInt < 0) continue;
                            class_2487 itemCompound = itemsTag.method_10562(key);
                            if (dataVersion != currentDataVersion) {
                                try {
                                    Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)itemCompound);
                                    Dynamic output = class_3551.method_15450().update(class_1208.field_5712, dynamic, dataVersion, currentDataVersion);
                                    itemCompound = (class_2487)output.getValue();
                                }
                                catch (Exception e) {
                                    Axiom.LOGGER.error("Failed to data fix item stack for hotbar", e);
                                }
                            }
                            if (!(itemStackOptional = Optional.ofNullable(class_1799.method_57359((class_7225.class_7874)player.method_56673(), (class_2487)itemCompound))).isPresent()) continue;
                            items.put(keyInt, (Object)itemStackOptional.get());
                        }
                        if (dataVersion != currentDataVersion) {
                            HotbarManager.trySave(player, true);
                        }
                    }
                    catch (Exception e) {
                        Axiom.LOGGER.error("Failed to load hotbars", e);
                    }
                }
            }
        }
    }

    public static int findHotbarWithMatchingItem(class_1799 matching) {
        for (Int2ObjectMap.Entry entry : items.int2ObjectEntrySet()) {
            int hotbarIndex;
            class_1799 itemStack = (class_1799)entry.getValue();
            if (itemStack == null || itemStack.method_7960() || (hotbarIndex = entry.getIntKey() / 9) == activeHotbarIndex || !class_1799.method_31577((class_1799)matching, (class_1799)itemStack)) continue;
            return hotbarIndex;
        }
        return -1;
    }

    public static int getActiveHotbarIndex() {
        return activeHotbarIndex;
    }

    public static void setActiveHotbarIndex(int activeHotbarIndex) {
        if (activeHotbarIndex == HotbarManager.activeHotbarIndex) {
            return;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return;
        }
        if (!class_310.method_1551().field_1724.method_56992()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 oldStack = player.method_31548().method_5438(i);
            if (oldStack.method_7960()) {
                items.remove(HotbarManager.activeHotbarIndex * 9 + i);
            } else {
                items.put(HotbarManager.activeHotbarIndex * 9 + i, (Object)oldStack);
            }
            class_1799 itemStack = HotbarManager.getItemStack(activeHotbarIndex, i);
            player.method_31548().method_5447(i, itemStack);
            gameMode.method_2909(itemStack, 36 + i);
        }
        HotbarManager.activeHotbarIndex = activeHotbarIndex;
        player.field_7498.method_7623();
        if (saveTimer <= 0) {
            saveTimer = 200;
        }
    }

    public static void setItemStack(int hotbarIndex, int itemIndex, class_1799 itemStack) {
        if (hotbarIndex == activeHotbarIndex) {
            class_636 gameMode = class_310.method_1551().field_1761;
            if (gameMode == null) {
                return;
            }
            if (!class_310.method_1551().field_1724.method_56992()) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            player.method_31548().method_5447(itemIndex, itemStack);
            gameMode.method_2909(itemStack, 36 + itemIndex);
            player.field_7498.method_7623();
        } else {
            if (itemStack.method_7960()) {
                items.remove(hotbarIndex * 9 + itemIndex);
            } else {
                items.put(hotbarIndex * 9 + itemIndex, (Object)itemStack.method_7972());
            }
            if (saveTimer <= 0) {
                saveTimer = 200;
            }
        }
    }

    public static class_1799 getItemStack(int hotbarIndex, int itemIndex) {
        if (hotbarIndex == activeHotbarIndex) {
            return class_310.method_1551().field_1724.method_31548().method_5438(itemIndex).method_7972();
        }
        return Objects.requireNonNullElse((class_1799)items.get(hotbarIndex * 9 + itemIndex), class_1799.field_8037).method_7972();
    }
}

